/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.jpf.jvm.bytecode;

import gov.nasa.jpf.jvm.ClassInfo;
import gov.nasa.jpf.jvm.DynamicArea;
import gov.nasa.jpf.jvm.ElementInfo;
import gov.nasa.jpf.jvm.KernelState;
import gov.nasa.jpf.jvm.SystemState;
import gov.nasa.jpf.jvm.ThreadInfo;
import gov.nasa.jpf.jvm.bytecode.Instruction;
import org.apache.bcel.classfile.ConstantPool;

public class MULTIANEWARRAY
extends Instruction {
    private String type;
    private int dimensions;

    @Override
    public void setPeer(org.apache.bcel.generic.Instruction i, ConstantPool cp) {
        this.type = cp.constantToString(cp.getConstant(((org.apache.bcel.generic.MULTIANEWARRAY)i).getIndex()));
        this.dimensions = ((org.apache.bcel.generic.MULTIANEWARRAY)i).getDimensions();
    }

    public static int allocateArray(DynamicArea heap, String type, int[] dim, ThreadInfo ti, int d) {
        int l = dim[d];
        int arrayRef = heap.newArray(type.substring(d + 1), l, ti);
        Object e = heap.get(arrayRef);
        if (dim.length > d + 1) {
            for (int i = 0; i < l; ++i) {
                ((ElementInfo)e).setElement(i, MULTIANEWARRAY.allocateArray(heap, type, dim, ti, d + 1));
            }
        }
        return arrayRef;
    }

    @Override
    public Instruction execute(SystemState ss, KernelState ks, ThreadInfo ti) {
        int[] dim = new int[this.dimensions];
        for (int i = this.dimensions - 1; i >= 0; --i) {
            dim[i] = ti.pop();
        }
        ClassInfo ci = ClassInfo.getClassInfo(this.type);
        if (!ci.isInitialized()) {
            ci.loadAndInitialize(ti);
        }
        int arrayRef = MULTIANEWARRAY.allocateArray(ks.da, this.type, dim, ti, 0);
        ti.push(arrayRef, true);
        return this.getNext(ti);
    }

    @Override
    public int getLength() {
        return 4;
    }

    @Override
    public int getByteCode() {
        return 197;
    }
}

