/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.jpf.jvm.bytecode;

import gov.nasa.jpf.jvm.ChoiceGenerator;
import gov.nasa.jpf.jvm.ElementInfo;
import gov.nasa.jpf.jvm.KernelState;
import gov.nasa.jpf.jvm.SystemState;
import gov.nasa.jpf.jvm.ThreadInfo;
import gov.nasa.jpf.jvm.bytecode.Instruction;
import gov.nasa.jpf.jvm.bytecode.LockInstruction;
import org.apache.bcel.classfile.ConstantPool;

public class MONITOREXIT
extends LockInstruction {
    @Override
    public void setPeer(org.apache.bcel.generic.Instruction i, ConstantPool cp) {
    }

    @Override
    public Instruction execute(SystemState ss, KernelState ks, ThreadInfo ti) {
        int objref = ti.peek();
        if (objref == -1) {
            return ti.createAndThrowException("java.lang.NullPointerException", "attempt to release lock for null object");
        }
        this.lastLockRef = objref;
        Object ei = ks.da.get(objref);
        if (!ti.isFirstStepInsn()) {
            ((ElementInfo)ei).unlock(ti);
            ChoiceGenerator<ThreadInfo> cg = ss.getSchedulerFactory().createMonitorExitCG((ElementInfo)ei, ti);
            if (cg != null) {
                ss.setNextChoiceGenerator(cg);
                return this;
            }
        }
        ti.pop();
        return this.getNext(ti);
    }

    @Override
    public int getByteCode() {
        return 195;
    }
}

