/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.jpf.jvm.bytecode;

import gov.nasa.jpf.jvm.ChoiceGenerator;
import gov.nasa.jpf.jvm.ElementInfo;
import gov.nasa.jpf.jvm.KernelState;
import gov.nasa.jpf.jvm.SystemState;
import gov.nasa.jpf.jvm.ThreadInfo;
import gov.nasa.jpf.jvm.bytecode.Instruction;
import gov.nasa.jpf.jvm.bytecode.LockInstruction;
import org.apache.bcel.classfile.ConstantPool;

public class MONITORENTER
extends LockInstruction {
    @Override
    public void setPeer(org.apache.bcel.generic.Instruction i, ConstantPool cp) {
    }

    @Override
    public Instruction execute(SystemState ss, KernelState ks, ThreadInfo ti) {
        int objref = ti.peek();
        if (objref == -1) {
            return ti.createAndThrowException("java.lang.NullPointerException", "attempt to acquire lock for null object");
        }
        this.lastLockRef = objref;
        Object ei = ks.da.get(objref);
        if (((ElementInfo)ei).getLockingThread() == ti) {
            ti.pop();
            ((ElementInfo)ei).lock(ti);
            return this.getNext(ti);
        }
        if (!ti.isFirstStepInsn()) {
            ChoiceGenerator<ThreadInfo> cg;
            if (!((ElementInfo)ei).canLock(ti)) {
                ((ElementInfo)ei).block(ti);
            }
            if ((cg = ss.getSchedulerFactory().createMonitorEnterCG((ElementInfo)ei, ti)) != null) {
                if (!ti.isBlocked()) {
                    ((ElementInfo)ei).registerLockContender(ti);
                }
                ss.setNextChoiceGenerator(cg);
                return this;
            }
            assert (!ti.isBlocked()) : "scheduling policy did not return ChoiceGenerator for blocking MONITOR_ENTER";
        }
        ti.pop();
        ((ElementInfo)ei).lock(ti);
        return this.getNext(ti);
    }

    @Override
    public int getByteCode() {
        return 194;
    }
}

