/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.jpf.jvm.bytecode;

import gov.nasa.jpf.jvm.ArrayIndexOutOfBoundsExecutiveException;
import gov.nasa.jpf.jvm.ElementInfo;
import gov.nasa.jpf.jvm.ThreadInfo;
import gov.nasa.jpf.jvm.bytecode.ArrayStoreInstruction;

public abstract class LongArrayStoreInstruction
extends ArrayStoreInstruction {
    @Override
    protected void setField(ElementInfo e, int index, long value) throws ArrayIndexOutOfBoundsExecutiveException {
        e.checkLongArrayBounds(index);
        e.setLongElement(index, value);
    }

    @Override
    protected int getElementSize() {
        return 2;
    }

    @Override
    protected long getValue(ThreadInfo th) {
        return th.longPop();
    }

    @Override
    int peekArrayRef(ThreadInfo ti) {
        return ti.peek(3);
    }
}

