/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.jpf.jvm.bytecode;

import gov.nasa.jpf.jvm.KernelState;
import gov.nasa.jpf.jvm.SystemState;
import gov.nasa.jpf.jvm.ThreadInfo;
import gov.nasa.jpf.jvm.bytecode.Instruction;
import gov.nasa.jpf.jvm.bytecode.LocalVariableInstruction;
import gov.nasa.jpf.jvm.bytecode.StoreInstruction;

public class LSTORE
extends LocalVariableInstruction
implements StoreInstruction {
    @Override
    public Instruction execute(SystemState ss, KernelState ks, ThreadInfo th) {
        th.storeLongOperand(this.index);
        return this.getNext(th);
    }

    @Override
    public int getLength() {
        if (this.index > 3) {
            return 2;
        }
        return 1;
    }

    @Override
    public int getByteCode() {
        switch (this.index) {
            case 0: {
                return 63;
            }
            case 1: {
                return 64;
            }
            case 2: {
                return 65;
            }
            case 3: {
                return 66;
            }
        }
        return 55;
    }

    @Override
    public String getMnemonic() {
        String mnemonic = "lstore";
        if (this.index >= 0) {
            return mnemonic + '_' + this.index;
        }
        return mnemonic;
    }
}

