/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.jpf.jvm.bytecode;

import gov.nasa.jpf.jvm.ChoiceGenerator;
import gov.nasa.jpf.jvm.ClassInfo;
import gov.nasa.jpf.jvm.DynamicArea;
import gov.nasa.jpf.jvm.ElementInfo;
import gov.nasa.jpf.jvm.KernelState;
import gov.nasa.jpf.jvm.MethodInfo;
import gov.nasa.jpf.jvm.NativePeer;
import gov.nasa.jpf.jvm.StackFrame;
import gov.nasa.jpf.jvm.SystemState;
import gov.nasa.jpf.jvm.ThreadInfo;
import gov.nasa.jpf.jvm.Types;
import gov.nasa.jpf.jvm.bytecode.Instruction;
import org.apache.bcel.classfile.ConstantPool;
import org.apache.bcel.generic.ConstantPoolGen;

public abstract class InvokeInstruction
extends Instruction {
    protected String cname;
    protected String mname;
    protected String signature;
    protected int argSize = -1;
    protected int lastObj = Integer.MIN_VALUE;
    protected MethodInfo invokedMethod;
    protected Object[] arguments;

    protected InvokeInstruction() {
    }

    @Override
    public void setPeer(org.apache.bcel.generic.Instruction i, ConstantPool cp) {
        ConstantPoolGen cpg = ClassInfo.getConstantPoolGen(cp);
        org.apache.bcel.generic.InvokeInstruction ii = (org.apache.bcel.generic.InvokeInstruction)i;
        this.cname = ii.getReferenceType(cpg).toString();
        this.signature = ii.getSignature(cpg);
        this.mname = MethodInfo.getUniqueName(ii.getMethodName(cpg), this.signature);
    }

    @Override
    public int getLength() {
        return 3;
    }

    public void initialize(MethodInfo owner, String clsName, String mthName, String sig, int off, int pos) {
        this.mi = owner;
        this.cname = clsName;
        this.mname = mthName + sig;
        this.signature = sig;
        this.offset = off;
        this.position = pos;
    }

    public String getInvokedMethodClassName() {
        return this.cname;
    }

    public String getInvokedMethodSignature() {
        return this.signature;
    }

    public String getInvokedMethodName() {
        return this.mname;
    }

    public abstract MethodInfo getInvokedMethod(ThreadInfo var1);

    public MethodInfo getInvokedMethod() {
        if (this.invokedMethod == null) {
            this.invokedMethod = this.getInvokedMethod(ThreadInfo.getCurrentThread());
        }
        return this.invokedMethod;
    }

    StackFrame getCallerFrame(ThreadInfo ti, MethodInfo callee) {
        StackFrame frame = null;
        frame = this.isCompleted(ti) && callee.isMJI() ? NativePeer.getLastCaller() : ti.getStackFrameExecuting(this);
        return frame;
    }

    public Object[] getArgumentValues(ThreadInfo ti) {
        MethodInfo callee = this.getInvokedMethod(ti);
        StackFrame frame = this.getCallerFrame(ti, callee);
        assert (frame != null) : "can't find caller stackframe for: " + this;
        return this.getArgsFromCaller(frame, callee);
    }

    public Object[] getArgumentAttrs(ThreadInfo ti) {
        MethodInfo callee = this.getInvokedMethod(ti);
        StackFrame frame = this.getCallerFrame(ti, callee);
        assert (frame != null) : "can't find caller stackframe for: " + this;
        return frame.getArgumentAttrs(callee);
    }

    Object[] getArgsFromCaller(StackFrame frame, MethodInfo callee) {
        int n = callee.getNumberOfArguments();
        Object[] args = new Object[n];
        byte[] at = callee.getArgumentTypes();
        int off = 0;
        block11: for (int i = n - 1; i >= 0; --i) {
            switch (at[i]) {
                case 13: 
                case 14: {
                    int ref = frame.peek(off);
                    args[i] = ref >= 0 ? DynamicArea.getHeap().get(ref) : null;
                    ++off;
                    continue block11;
                }
                case 11: {
                    args[i] = new Long(frame.longPeek(off));
                    off += 2;
                    continue block11;
                }
                case 7: {
                    args[i] = new Double(Types.longToDouble(frame.longPeek(off)));
                    off += 2;
                    continue block11;
                }
                case 4: {
                    args[i] = new Boolean(frame.peek(off) != 0);
                    ++off;
                    continue block11;
                }
                case 8: {
                    args[i] = new Byte((byte)frame.peek(off));
                    ++off;
                    continue block11;
                }
                case 5: {
                    args[i] = new Character((char)frame.peek(off));
                    ++off;
                    continue block11;
                }
                case 9: {
                    args[i] = new Short((short)frame.peek(off));
                    ++off;
                    continue block11;
                }
                case 10: {
                    args[i] = new Integer(frame.peek(off));
                    ++off;
                    continue block11;
                }
                case 6: {
                    args[i] = new Float(Types.intToFloat(frame.peek(off)));
                    ++off;
                    continue block11;
                }
            }
        }
        return args;
    }

    public int getArgSize() {
        if (this.argSize < 0) {
            this.argSize = Types.getArgumentsSize(this.signature) + 1;
        }
        return this.argSize;
    }

    public int getReturnType() {
        return Types.getReturnType(this.signature);
    }

    public boolean isReferenceReturnType() {
        byte r = Types.getReturnType(this.signature);
        return r == 14 || r == 13;
    }

    public String getReturnTypeName() {
        return Types.getReturnTypeName(this.signature);
    }

    @Override
    public boolean isCompleted(ThreadInfo ti) {
        StackFrame topFrame = ti.getTopFrame();
        Instruction pc = topFrame.getPC();
        if (pc == this) {
            return false;
        }
        if (topFrame.getMethodInfo() == this.mi) {
            return true;
        }
        return pc == this.getInvokedMethod().getInstruction(0);
    }

    public Object getFieldOrArgumentValue(String id, ThreadInfo ti) {
        Object v = null;
        v = this.getArgumentValue(id, ti);
        if (v == null) {
            v = this.getFieldValue(id, ti);
        }
        return v;
    }

    public abstract Object getFieldValue(String var1, ThreadInfo var2);

    public Object getArgumentValue(String id, ThreadInfo ti) {
        MethodInfo mi = this.getInvokedMethod();
        String[] localNames = mi.getLocalVariableNames();
        Object[] args = this.getArgumentValues(ti);
        if (localNames != null) {
            int j = mi.isStatic() ? 0 : 1;
            int i = 0;
            while (i < args.length) {
                Object a = args[i];
                if (localNames[j].equals(id)) {
                    return a;
                }
                if (a instanceof Long || a instanceof Double) {
                    ++j;
                }
                ++i;
                ++j;
            }
        }
        return null;
    }

    protected ChoiceGenerator<?> getSyncCG(int objRef, MethodInfo mi, SystemState ss, KernelState ks, ThreadInfo ti) {
        Object ei = ks.da.get(objRef);
        if (((ElementInfo)ei).getLockingThread() == ti) {
            assert (((ElementInfo)ei).getLockCount() > 0);
            return null;
        }
        if (!ti.isFirstStepInsn()) {
            ChoiceGenerator<ThreadInfo> cg;
            if (!((ElementInfo)ei).canLock(ti)) {
                ((ElementInfo)ei).block(ti);
            }
            if ((cg = ss.getSchedulerFactory().createSyncMethodEnterCG((ElementInfo)ei, ti)) != null) {
                if (!ti.isBlocked()) {
                    ((ElementInfo)ei).registerLockContender(ti);
                }
                return cg;
            }
            assert (!ti.isBlocked()) : "scheduling policy did not return ChoiceGenerator for blocking INVOKE";
        }
        return null;
    }
}

