/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.jpf.jvm.bytecode;

import gov.nasa.jpf.jvm.ClassInfo;
import gov.nasa.jpf.jvm.DynamicArea;
import gov.nasa.jpf.jvm.ElementInfo;
import gov.nasa.jpf.jvm.FieldInfo;
import gov.nasa.jpf.jvm.ThreadInfo;
import gov.nasa.jpf.jvm.bytecode.FieldInstruction;

public abstract class InstanceFieldInstruction
extends FieldInstruction {
    protected int lastThis = -1;

    @Override
    public FieldInfo getFieldInfo() {
        ClassInfo ci;
        if (this.fi == null && (ci = ClassInfo.getClassInfo(this.className)) != null) {
            this.fi = ci.getInstanceField(this.fname);
        }
        return this.fi;
    }

    protected boolean isSchedulingRelevant(ThreadInfo ti, int objRef) {
        DynamicArea da = DynamicArea.getHeap();
        if (!ti.hasOtherRunnables() || !da.isSchedulingRelevantObject(objRef)) {
            return false;
        }
        if (ti.usePorSyncDetection()) {
            if (skipFinals && this.fi.isFinal()) {
                return false;
            }
            if (this.fname.startsWith("this$")) {
                return false;
            }
            if (!this.checkFieldFilter()) {
                return false;
            }
            if (this.isMonitorEnterPrologue()) {
                return false;
            }
            if (!ti.getMethod().isSyncRelevant() || this.isLockProtected((ElementInfo)da.get(objRef), ti)) {
                return false;
            }
        }
        return true;
    }

    protected boolean isNewPorFieldBoundary(ThreadInfo ti, FieldInfo fi, int objRef) {
        return !ti.isFirstStepInsn() && ti.usePorFieldBoundaries() && this.isSchedulingRelevant(ti, objRef);
    }

    public int getLastThis() {
        return this.lastThis;
    }

    @Override
    public ElementInfo getLastElementInfo() {
        if (this.lastThis != -1) {
            return DynamicArea.getHeap().get(this.lastThis);
        }
        return null;
    }

    @Override
    public abstract ElementInfo peekElementInfo(ThreadInfo var1);

    public String getFieldDescriptor() {
        ElementInfo ei = this.getLastElementInfo();
        FieldInfo fi = this.getFieldInfo();
        return ei.toString() + '.' + fi.getName();
    }
}

