/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.jpf.jvm.bytecode;

import gov.nasa.jpf.jvm.ChoiceGenerator;
import gov.nasa.jpf.jvm.ClassInfo;
import gov.nasa.jpf.jvm.DynamicArea;
import gov.nasa.jpf.jvm.ElementInfo;
import gov.nasa.jpf.jvm.KernelState;
import gov.nasa.jpf.jvm.MethodInfo;
import gov.nasa.jpf.jvm.SystemState;
import gov.nasa.jpf.jvm.ThreadInfo;
import gov.nasa.jpf.jvm.Types;
import gov.nasa.jpf.jvm.bytecode.Instruction;
import gov.nasa.jpf.jvm.bytecode.InvokeInstruction;

public class INVOKESTATIC
extends InvokeInstruction {
    ClassInfo ci;

    ClassInfo getClassInfo() {
        if (this.ci == null) {
            this.ci = ClassInfo.getClassInfo(this.cname);
        }
        return this.ci;
    }

    @Override
    public int getByteCode() {
        return 184;
    }

    @Override
    public boolean isExecutable(SystemState ss, KernelState ks, ThreadInfo ti) {
        MethodInfo mi = this.getInvokedMethod();
        if (mi == null) {
            return true;
        }
        return mi.isExecutable(ti);
    }

    @Override
    public boolean examineAbstraction(SystemState ss, KernelState ks, ThreadInfo ti) {
        MethodInfo mi = this.getInvokedMethod(ti);
        if (mi == null) {
            return true;
        }
        return !this.ci.isStaticMethodAbstractionDeterministic(ti, mi);
    }

    @Override
    public Instruction execute(SystemState ss, KernelState ks, ThreadInfo ti) {
        DynamicArea da;
        Object ei;
        MethodInfo callee = this.getInvokedMethod(ti);
        if (callee == null) {
            return ti.createAndThrowException("java.lang.NoSuchMethodException", this.cname + '.' + this.mname);
        }
        ClassInfo ci = callee.getClassInfo();
        if (this.requiresClinitCalls(ti, ci)) {
            return ti.getPC();
        }
        if (callee.isSynchronized() && ((ElementInfo)(ei = (da = ti.getVM().getDynamicArea()).get(ci.getClassObjectRef()))).getLockingThread() != ti && !ti.isFirstStepInsn()) {
            ChoiceGenerator<ThreadInfo> cg;
            if (!((ElementInfo)ei).canLock(ti)) {
                ((ElementInfo)ei).block(ti);
            }
            if ((cg = ss.getSchedulerFactory().createSyncMethodEnterCG((ElementInfo)ei, ti)) != null) {
                if (!ti.isBlocked()) {
                    ((ElementInfo)ei).registerLockContender(ti);
                }
                ss.setNextChoiceGenerator(cg);
                return this;
            }
            assert (!ti.isBlocked()) : "scheduling policy did not return ChoiceGenerator for blocking INVOKE";
        }
        return callee.execute(ti);
    }

    @Override
    public MethodInfo getInvokedMethod(ThreadInfo ti) {
        return this.getInvokedMethod();
    }

    @Override
    public MethodInfo getInvokedMethod() {
        ClassInfo clsInfo = this.getClassInfo();
        if (this.invokedMethod == null) {
            this.invokedMethod = clsInfo.getMethod(this.mname, true);
        }
        return this.invokedMethod;
    }

    @Override
    public int getArgSize() {
        if (this.argSize < 0) {
            this.argSize = Types.getArgumentsSize(this.signature);
        }
        return this.argSize;
    }

    @Override
    public String toString() {
        return "invokestatic " + this.getInvokedMethod().getFullName();
    }

    @Override
    public Object getFieldValue(String id, ThreadInfo ti) {
        return this.getClassInfo().getStaticFieldValueObject(id);
    }
}

