/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.jpf.jvm.bytecode;

import gov.nasa.jpf.jvm.KernelState;
import gov.nasa.jpf.jvm.SystemState;
import gov.nasa.jpf.jvm.ThreadInfo;
import gov.nasa.jpf.jvm.bytecode.Instruction;
import org.apache.bcel.classfile.ConstantPool;

public class ICONST
extends Instruction {
    private int value;

    @Override
    public void setPeer(org.apache.bcel.generic.Instruction i, ConstantPool cp) {
        this.value = ((org.apache.bcel.generic.ICONST)i).getValue().intValue();
    }

    @Override
    public Instruction execute(SystemState ss, KernelState ks, ThreadInfo th) {
        th.push(this.value, false);
        return this.getNext(th);
    }

    public int getValue() {
        return this.value;
    }

    @Override
    public int getByteCode() {
        assert (this.value >= -1 && this.value < 6) : "illegal iconst value: " + this.value;
        switch (this.value) {
            case -1: {
                return 2;
            }
            case 0: {
                return 3;
            }
            case 1: {
                return 4;
            }
            case 2: {
                return 5;
            }
            case 3: {
                return 6;
            }
            case 4: {
                return 7;
            }
            case 5: {
                return 8;
            }
        }
        return 0;
    }

    @Override
    public String getMnemonic() {
        String s = "iconst_";
        if (this.value == -1) {
            return s + "m1";
        }
        return s + this.value;
    }
}

