/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.jpf.jvm.bytecode;

import gov.nasa.jpf.JPFException;
import gov.nasa.jpf.jvm.DynamicArea;
import gov.nasa.jpf.jvm.ElementInfo;
import gov.nasa.jpf.jvm.FieldInfo;
import gov.nasa.jpf.jvm.KernelState;
import gov.nasa.jpf.jvm.SystemState;
import gov.nasa.jpf.jvm.ThreadInfo;
import gov.nasa.jpf.jvm.bytecode.InstanceFieldInstruction;
import gov.nasa.jpf.jvm.bytecode.Instruction;

public class GETFIELD
extends InstanceFieldInstruction {
    public void initialize(String fname, String fclsName) {
        this.fname = fname;
        this.className = fclsName;
        if (fclsName.equals("long") || fclsName.equals("double")) {
            this.size = 2;
            this.isReferenceField = false;
        } else {
            this.size = 1;
            this.isReferenceField = !fclsName.equals("boolean") && !fclsName.equals("byte") && !fclsName.equals("char") && !fclsName.equals("short") && !fclsName.equals("int");
        }
    }

    @Override
    public Instruction execute(SystemState ss, KernelState ks, ThreadInfo ti) {
        int objRef;
        this.lastThis = objRef = ti.peek();
        if (objRef == -1) {
            return ti.createAndThrowException("java.lang.NullPointerException", "referencing field '" + this.fname + "' on null object");
        }
        Object ei = DynamicArea.getHeap().get(objRef);
        FieldInfo fi = this.getFieldInfo();
        if (fi == null) {
            return ti.createAndThrowException("java.lang.NoSuchFieldError", "referencing field '" + this.fname + "' in " + ei);
        }
        if (this.isNewPorFieldBoundary(ti, fi, objRef) && this.createAndSetFieldCG(ss, (ElementInfo)ei, ti)) {
            return this;
        }
        ti.pop();
        Object attr = ((ElementInfo)ei).getFieldAttr(fi);
        switch (fi.getStorageSize()) {
            case 1: {
                ti.push(((ElementInfo)ei).getIntField(fi), fi.isReference());
                if (attr == null) break;
                ti.setOperandAttrNoClone(attr);
                break;
            }
            case 2: {
                ti.longPush(((ElementInfo)ei).getLongField(fi));
                if (attr == null) break;
                ti.setLongOperandAttrNoClone(attr);
                break;
            }
            default: {
                throw new JPFException("invalid field type");
            }
        }
        return this.getNext(ti);
    }

    @Override
    public ElementInfo peekElementInfo(ThreadInfo ti) {
        int objRef = ti.peek();
        Object ei = DynamicArea.getHeap().get(objRef);
        return ei;
    }

    @Override
    public int getLength() {
        return 3;
    }

    @Override
    public int getByteCode() {
        return 180;
    }
}

