/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.jpf.jvm.bytecode;

import gov.nasa.jpf.Config;
import gov.nasa.jpf.JPFException;
import gov.nasa.jpf.jvm.ChoiceGenerator;
import gov.nasa.jpf.jvm.ClassInfo;
import gov.nasa.jpf.jvm.ElementInfo;
import gov.nasa.jpf.jvm.FieldInfo;
import gov.nasa.jpf.jvm.FieldLockInfo;
import gov.nasa.jpf.jvm.SystemState;
import gov.nasa.jpf.jvm.ThreadInfo;
import gov.nasa.jpf.jvm.bytecode.ASTORE;
import gov.nasa.jpf.jvm.bytecode.DUP;
import gov.nasa.jpf.jvm.bytecode.Instruction;
import gov.nasa.jpf.jvm.bytecode.MONITORENTER;
import gov.nasa.jpf.jvm.bytecode.VariableAccessor;
import org.apache.bcel.classfile.ConstantPool;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.ReferenceType;
import org.apache.bcel.generic.Type;

public abstract class FieldInstruction
extends Instruction
implements VariableAccessor {
    static FieldLockInfo prototype;
    static String[] excludeFields;
    static String[] includeFields;
    static boolean skipFinals;
    protected String fname;
    protected String className;
    protected String varId;
    protected FieldInfo fi;
    protected int size;
    protected boolean isReferenceField;

    public static void init(Config config) throws Config.Exception {
        if (config.getBoolean("vm.por") && config.getBoolean("vm.por.sync_detection")) {
            prototype = config.getEssentialInstance("vm.por.fieldlockinfo.class", FieldLockInfo.class);
            excludeFields = config.getStringArray("vm.por.exclude_fields");
            includeFields = config.getStringArray("vm.por.include_fields");
            skipFinals = config.getBoolean("vm.por.skip_finals", true);
        }
    }

    @Override
    public void setPeer(org.apache.bcel.generic.Instruction i, ConstantPool cp) {
        org.apache.bcel.generic.FieldInstruction fi = (org.apache.bcel.generic.FieldInstruction)i;
        ConstantPoolGen cpg = ClassInfo.getConstantPoolGen(cp);
        this.fname = fi.getFieldName(cpg);
        this.className = fi.getReferenceType(cpg).toString();
        Type ft = fi.getFieldType(cpg);
        if (ft instanceof ReferenceType) {
            this.isReferenceField = true;
        }
        this.size = ft.getSize();
    }

    public abstract FieldInfo getFieldInfo();

    public abstract ElementInfo getLastElementInfo();

    public abstract ElementInfo peekElementInfo(ThreadInfo var1);

    public boolean isReferenceField() {
        return this.isReferenceField;
    }

    public int getFieldSize() {
        return this.size;
    }

    public String getId(ElementInfo ei) {
        if (ei != null) {
            return ei.toString() + '.' + this.fname;
        }
        return "?." + this.fname;
    }

    @Override
    public String getVariableId() {
        if (this.varId == null) {
            this.varId = this.className + '.' + this.fname;
        }
        return this.varId;
    }

    protected boolean isLockProtected(ElementInfo ei, ThreadInfo ti) {
        FieldLockInfo flInfoNext;
        FieldInfo fi = this.getFieldInfo();
        FieldLockInfo flInfo = ei.getFieldLockInfo(fi);
        if (flInfo == null) {
            try {
                flInfoNext = (FieldLockInfo)prototype.clone();
            }
            catch (CloneNotSupportedException cnsx) {
                throw new JPFException(cnsx);
            }
        } else {
            flInfoNext = flInfo.checkProtection(ei, fi, ti);
        }
        if (flInfoNext != flInfo) {
            ei.setFieldLockInfo(fi, flInfoNext);
        }
        return flInfoNext.isProtected();
    }

    protected boolean isMonitorEnterPrologue() {
        int off = this.offset + 1;
        Instruction[] code = this.mi.getInstructions();
        if (off < code.length - 3 && code[off] instanceof DUP) {
            if (code[++off] instanceof ASTORE) {
                ++off;
            }
            if (code[off] instanceof MONITORENTER) {
                return true;
            }
        }
        return false;
    }

    protected boolean checkFieldFilter() {
        int i;
        String fid = this.getVariableId();
        if (excludeFields != null) {
            for (i = 0; i < excludeFields.length; ++i) {
                if (!fid.startsWith(excludeFields[i])) continue;
                return false;
            }
        }
        if (includeFields != null) {
            for (i = 0; i < includeFields.length; ++i) {
                if (!fid.startsWith(includeFields[i])) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    protected boolean createAndSetFieldCG(SystemState ss, ElementInfo ei, ThreadInfo ti) {
        ChoiceGenerator<ThreadInfo> cg;
        if (this.checkFieldFilter() && (cg = ss.getSchedulerFactory().createSharedFieldAccessCG(ei, ti)) != null) {
            ss.setNextChoiceGenerator(cg);
            ti.skipInstructionLogging();
            return true;
        }
        return false;
    }
}

