/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.jpf.jvm.bytecode;

import gov.nasa.jpf.jvm.KernelState;
import gov.nasa.jpf.jvm.SystemState;
import gov.nasa.jpf.jvm.ThreadInfo;
import gov.nasa.jpf.jvm.bytecode.Instruction;
import gov.nasa.jpf.jvm.bytecode.LocalVariableInstruction;

public class DLOAD
extends LocalVariableInstruction {
    @Override
    public Instruction execute(SystemState ss, KernelState ks, ThreadInfo th) {
        th.pushLongLocal(this.index);
        return this.getNext(th);
    }

    @Override
    public int getLength() {
        if (this.index > 3) {
            return 2;
        }
        return 1;
    }

    @Override
    public int getByteCode() {
        switch (this.index) {
            case 0: {
                return 38;
            }
            case 1: {
                return 39;
            }
            case 2: {
                return 40;
            }
            case 3: {
                return 41;
            }
        }
        return 24;
    }

    @Override
    public String getMnemonic() {
        String mnemonic = "dload";
        if (this.index >= 0) {
            return mnemonic + '_' + this.index;
        }
        return mnemonic;
    }
}

