/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.jpf.jvm.bytecode;

import gov.nasa.jpf.jvm.ClassInfo;
import gov.nasa.jpf.jvm.ElementInfo;
import gov.nasa.jpf.jvm.KernelState;
import gov.nasa.jpf.jvm.SystemState;
import gov.nasa.jpf.jvm.ThreadInfo;
import gov.nasa.jpf.jvm.Types;
import gov.nasa.jpf.jvm.bytecode.Instruction;
import org.apache.bcel.classfile.ConstantPool;

public class CHECKCAST
extends Instruction {
    String type;

    @Override
    public void setPeer(org.apache.bcel.generic.Instruction i, ConstantPool cp) {
        String t = cp.constantToString(cp.getConstant(((org.apache.bcel.generic.CHECKCAST)i).getIndex()));
        this.type = Types.getCanonicalTypeName(t);
    }

    public String getTypeName() {
        return this.type;
    }

    @Override
    public Instruction execute(SystemState ss, KernelState ks, ThreadInfo th) {
        int objref = th.pop();
        if (objref == -1) {
            th.push(objref, true);
        } else {
            boolean isValid = false;
            Object e = ks.da.get(objref);
            ClassInfo eci = ((ElementInfo)e).getClassInfo();
            if (this.type.charAt(0) == '[') {
                if (eci.isArray()) {
                    ClassInfo cci = eci.getComponentClassInfo();
                    isValid = cci.isInstanceOf(this.type.substring(1));
                }
            } else {
                isValid = ((ElementInfo)e).getClassInfo().isInstanceOf(this.type);
            }
            if (isValid) {
                th.push(objref, true);
            } else {
                return th.createAndThrowException("java.lang.ClassCastException", "expected: " + this.type + " has: " + ((ElementInfo)e).getClassInfo().getName());
            }
        }
        return this.getNext(th);
    }

    @Override
    public int getLength() {
        return 3;
    }

    @Override
    public int getByteCode() {
        return 192;
    }
}

