/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.jpf.jvm.bytecode;

import gov.nasa.jpf.jvm.DynamicArea;
import gov.nasa.jpf.jvm.ThreadInfo;
import gov.nasa.jpf.jvm.bytecode.ReturnInstruction;
import org.apache.bcel.classfile.ConstantPool;
import org.apache.bcel.generic.Instruction;

public class ARETURN
extends ReturnInstruction {
    int ret;

    @Override
    public void setPeer(Instruction i, ConstantPool cp) {
    }

    @Override
    protected void storeReturnValue(ThreadInfo th) {
        this.ret = th.pop();
    }

    @Override
    protected void pushReturnValue(ThreadInfo th) {
        th.push(this.ret, true);
    }

    public int getReturnValue() {
        return this.ret;
    }

    @Override
    public Object getReturnValue(ThreadInfo ti) {
        if (!this.isCompleted(ti)) {
            this.ret = ti.peek();
        }
        if (this.ret == -1) {
            return null;
        }
        return DynamicArea.getHeap().get(this.ret);
    }

    @Override
    public int getByteCode() {
        return 176;
    }

    @Override
    public String toString() {
        return "areturn " + this.mi.getFullName();
    }
}

