/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.jpf.jvm.abstraction.symmetry;

import java.util.Arrays;

public class Threads {
    public final Runnable[] targets;
    protected final int count;
    private boolean started = false;

    public Threads(Runnable[] targets) {
        this.targets = targets;
        this.count = targets.length;
    }

    public Threads(int count, Runnable singleTarget) {
        this.count = count;
        this.targets = new Runnable[count];
        Arrays.fill(this.targets, singleTarget);
    }

    public final void startAll() {
        this.doStartAll();
    }

    synchronized void doStartAll() {
        if (this.started) {
            throw new IllegalStateException();
        }
        this.preStart();
        this.started = true;
        for (int i = 0; i < this.count; ++i) {
            new Worker(this.targets[i]).start();
        }
        this.postStart();
    }

    protected synchronized void preStart() {
    }

    protected synchronized void postStart() {
    }

    class Worker
    extends Thread {
        Runnable target;

        public Worker(Runnable target) {
            this.target = target;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Threads threads = Threads.this;
            synchronized (threads) {
            }
            this.target.run();
        }
    }
}

