/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.jpf.jvm.abstraction.symmetry;

import gov.nasa.jpf.jvm.abstraction.symmetry.Threads;

public class JoinableThreads
extends Threads {
    private boolean started = false;
    private int aliveCount = 0;
    private boolean allCompleted = false;

    public JoinableThreads(Runnable[] targets) {
        super(targets);
    }

    public JoinableThreads(int count, Runnable singleTarget) {
        super(count, singleTarget);
    }

    @Override
    void doStartAll() {
        if (this.started) {
            throw new IllegalStateException();
        }
        this.preStart();
        this.started = true;
        this.aliveCount = this.count;
        for (int i = 0; i < this.count; ++i) {
            new JoinableWorker(this.targets[i]).start();
        }
        this.postStart();
    }

    protected synchronized void postCompletion() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void joinAll() throws InterruptedException {
        JoinableThreads joinableThreads = this;
        synchronized (joinableThreads) {
            while (!this.allCompleted) {
                this.wait();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void joinAllUninterrupted() {
        JoinableThreads joinableThreads = this;
        synchronized (joinableThreads) {
            while (!this.allCompleted) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    private class JoinableWorker
    extends Threads.Worker {
        public JoinableWorker(Runnable target) {
            super(JoinableThreads.this, target);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            JoinableThreads joinableThreads = JoinableThreads.this;
            synchronized (joinableThreads) {
            }
            try {
                this.target.run();
            }
            finally {
                joinableThreads = JoinableThreads.this;
                synchronized (joinableThreads) {
                    JoinableThreads.this.aliveCount--;
                    if (JoinableThreads.this.aliveCount == 0) {
                        JoinableThreads.this.allCompleted = true;
                        JoinableThreads.this.postCompletion();
                        JoinableThreads.this.notifyAll();
                    }
                }
            }
        }
    }
}

