/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.jpf.jvm.abstraction.symmetry;

import gov.nasa.jpf.util.ObjArray;

abstract class FastTable<V, EntryType extends Entry<V, EntryType>> {
    static final int INIT_TBL_POW = 7;
    static final double MAX_LOAD = 0.8;
    protected ObjArray<EntryType> table;
    protected int tblPow;
    protected int mask;
    protected int nextRehash;
    protected int size;

    FastTable() {
        this(7);
    }

    FastTable(int pow) {
        this.newTable(pow);
        this.size = 0;
    }

    void newTable(int pow) {
        this.tblPow = pow;
        this.table = new ObjArray(1 << this.tblPow);
        this.mask = this.table.length() - 1;
        this.nextRehash = (int)Math.ceil(0.8 * (double)this.table.length());
    }

    int getIndex(Object o) {
        int hc = System.identityHashCode(o);
        return (hc >> 3) + (hc << 3) & this.mask;
    }

    boolean maybeRehash() {
        if (this.size < this.nextRehash) {
            return false;
        }
        ObjArray<EntryType> old = this.table;
        this.newTable(this.tblPow + 1);
        int len = old.length();
        for (int i = 0; i < len; ++i) {
            this.addPostOrder((Entry)old.get(i));
        }
        return true;
    }

    private void addPostOrder(EntryType e) {
        if (e != null) {
            this.addPostOrder((Entry)((Entry)e).next);
            this.doAdd(e, this.getIndex(e));
        }
    }

    private void doAdd(EntryType e, int idx) {
        ((Entry)e).next = this.table.get(idx);
        this.table.set(idx, e);
    }

    EntryType getHelper(Object val, int idx) {
        Entry cur = (Entry)this.table.get(idx);
        while (cur != null) {
            if (cur.val == val) {
                return (EntryType)cur;
            }
            cur = (Entry)cur.next;
        }
        return null;
    }

    abstract EntryType create(V var1);

    EntryType strictAdd(V v) {
        int idx = this.getIndex(v);
        EntryType e = this.create(v);
        this.maybeRehash();
        this.doAdd(e, idx);
        ++this.size;
        return e;
    }

    EntryType ensureAdded(V v) {
        int idx = this.getIndex(v);
        EntryType e = this.getHelper(v, idx);
        if (e == null) {
            e = this.create(v);
            this.maybeRehash();
            this.doAdd(e, idx);
            ++this.size;
        }
        return e;
    }

    EntryType lookup(Object v) {
        int idx = this.getIndex(v);
        return this.getHelper(v, idx);
    }

    EntryType delete(Object v) {
        int idx = this.getIndex(v);
        Entry cur = (Entry)this.table.get(idx);
        Entry prev = null;
        while (cur != null) {
            if (cur.val == v) {
                if (prev != null) {
                    prev.next = cur.next;
                } else {
                    this.table.set(idx, cur.next);
                }
                cur.next = null;
                return (EntryType)cur;
            }
            prev = cur;
            cur = (Entry)cur.next;
        }
        return null;
    }

    int getPow() {
        return this.tblPow;
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public void clear() {
        this.table.nullify();
        this.size = 0;
    }

    static abstract class Entry<V, This> {
        V val;
        This next;

        Entry(V v) {
            this.val = v;
            this.next = null;
        }
    }
}

