/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.jpf.jvm.abstraction.symmetry;

import gov.nasa.jpf.jvm.abstraction.symmetry.EqSet;
import gov.nasa.jpf.jvm.abstraction.symmetry.FastTable;
import gov.nasa.jpf.jvm.abstraction.symmetry.SymEqCollection;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;

class FastEqSet<T>
extends FastTable<T, Entry<T>>
implements EqSet<T> {
    public FastEqSet(int pow) {
        super(pow);
    }

    public FastEqSet() {
    }

    @Override
    Entry<T> create(T t) {
        return new Entry<T>(t);
    }

    @Override
    public boolean add(T o) {
        int oldSize = this.size;
        this.ensureAdded(o);
        return this.size > oldSize;
    }

    @Override
    public boolean addAll(SymEqCollection<? extends T> c) {
        return this.addAll((Collection)((Object)c));
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        int oldSize = this.size;
        for (T o : c) {
            this.ensureAdded(o);
        }
        return oldSize > this.size;
    }

    @Override
    public boolean contains(Object o) {
        return this.lookup(o) != null;
    }

    @Override
    public boolean containsAll(SymEqCollection<?> c) {
        return this.containsAll((Collection)((Object)c));
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object e : c) {
            if (this.contains(e)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean remove(Object o) {
        return this.delete(o) != null;
    }

    @Override
    public boolean removeAll(SymEqCollection<?> c) {
        return this.removeAll((Collection)((Object)c));
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean modified = false;
        for (Object th : c) {
            modified |= this.remove(th);
        }
        return modified;
    }

    @Override
    public boolean retainAll(SymEqCollection<?> c) {
        return this.retainAll((Collection)((Object)c));
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        boolean modified = false;
        for (T e : this) {
            if (c.contains(e)) continue;
            modified |= this.remove(e);
        }
        return modified;
    }

    @Override
    public Object[] toArray() {
        Object[] arr = new Object[this.size()];
        return this.toArray((V[])arr);
    }

    @Override
    public <V> V[] toArray(V[] a) {
        if (a.length >= this.size()) {
            int pos = 0;
            for (T o : this) {
                a[pos++] = o;
            }
            return a;
        }
        return this.toArray();
    }

    @Override
    public FastEqSet<T> clone() {
        FastEqSet<T> that = new FastEqSet<T>(this.tblPow);
        for (T o : this) {
            that.strictAdd(o);
        }
        return that;
    }

    @Override
    public Iterator<T> iterator() {
        return new TblIterator();
    }

    protected class TblIterator
    implements Iterator<T> {
        int idx = -1;
        Entry<T> cur = null;

        public TblIterator() {
            this.advance();
        }

        void advance() {
            if (this.cur != null) {
                this.cur = (Entry)this.cur.next;
            }
            int len = FastEqSet.this.table.length();
            while (this.idx < len && this.cur == null) {
                ++this.idx;
                if (this.idx >= len) continue;
                this.cur = (Entry)FastEqSet.this.table.get(this.idx);
            }
        }

        @Override
        public boolean hasNext() {
            return this.idx < FastEqSet.this.table.length();
        }

        @Override
        public T next() {
            Entry e = this.cur;
            if (e == null) {
                throw new NoSuchElementException();
            }
            this.advance();
            return e.val;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    static class Entry<V>
    extends FastTable.Entry<V, Entry<V>> {
        Entry(V v) {
            super(v);
        }
    }
}

