/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.jpf.jvm.abstraction.symmetry;

import gov.nasa.jpf.jvm.ModelAPI;
import gov.nasa.jpf.jvm.Verify;
import gov.nasa.jpf.jvm.abstraction.symmetry.CanonicalEqBag;
import gov.nasa.jpf.jvm.abstraction.symmetry.CanonicalEqSet;
import gov.nasa.jpf.jvm.abstraction.symmetry.EqBag;
import gov.nasa.jpf.jvm.abstraction.symmetry.EqSet;
import gov.nasa.jpf.jvm.abstraction.symmetry.FastEqBag;
import gov.nasa.jpf.jvm.abstraction.symmetry.FastEqSet;
import gov.nasa.jpf.jvm.abstraction.symmetry.SymEqBag;
import gov.nasa.jpf.jvm.abstraction.symmetry.SymEqSet;

@ModelAPI
public abstract class CollectionFactory {
    static final CollectionFactory deflt;
    static final CollectionFactory canonical;
    static final CollectionFactory fast;

    public static <T> EqBag<T> newEqBag() {
        return deflt.createEqBag();
    }

    public static <T> EqSet<T> newEqSet() {
        return deflt.createEqSet();
    }

    public static <T> SymEqSet<T> newSymEqSet() {
        return deflt.createSymEqSet();
    }

    public static <T> SymEqBag<T> newSymEqBag() {
        return deflt.createSymEqBag();
    }

    abstract <T> EqBag<T> createEqBag();

    abstract <T> EqSet<T> createEqSet();

    abstract <T> SymEqSet<T> createSymEqSet();

    abstract <T> SymEqBag<T> createSymEqBag();

    static {
        canonical = new CanonicalFactory();
        fast = new FastFactory();
        deflt = Verify.vmIsMatchingStates() ? canonical : fast;
    }

    static class FastFactory
    extends CollectionFactory {
        FastFactory() {
        }

        @Override
        public <T> EqBag<T> createEqBag() {
            return new FastEqBag();
        }

        @Override
        public <T> EqSet<T> createEqSet() {
            return new FastEqSet();
        }

        @Override
        public <T> SymEqBag<T> createSymEqBag() {
            return new FastEqBag();
        }

        @Override
        public <T> SymEqSet<T> createSymEqSet() {
            return new FastEqSet();
        }
    }

    static class CanonicalFactory
    extends CollectionFactory {
        CanonicalFactory() {
        }

        @Override
        public <T> EqBag<T> createEqBag() {
            return new CanonicalEqBag();
        }

        @Override
        public <T> EqSet<T> createEqSet() {
            return new CanonicalEqSet();
        }

        @Override
        public <T> SymEqBag<T> createSymEqBag() {
            return new CanonicalEqBag();
        }

        @Override
        public <T> SymEqSet<T> createSymEqSet() {
            return new CanonicalEqSet();
        }
    }
}

