/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.jpf.jvm.abstraction.state;

import gov.nasa.jpf.util.IntTable;
import gov.nasa.jpf.util.IntVector;
import gov.nasa.jpf.util.ObjVector;
import java.util.Comparator;

public abstract class StateNode {
    public int vmNodeId = -2;
    public int linearNodeId = -2;
    protected static IntTable<Class<?>> nodeTypes = new IntTable(6);
    public static final int INVALID_LINEAR_ID = -2;
    public static final int NULL_LINEAR_ID = -1;
    public static final Comparator<StateNode> linearIdComparator = new Comparator<StateNode>(){

        @Override
        public int compare(StateNode o1, StateNode o2) {
            return StateNode.linearIdOf(o1) - StateNode.linearIdOf(o2);
        }
    };
    public static final int INVALID_VM_ID = -2;
    public static final int NULL_VM_ID = -1;
    public static final int ROOT_VM_ID = 1;
    public static final int CLASSES_VM_ID = 2;
    public static final int THREADS_VM_ID = 3;
    public static final int THREAD_VM_ID_START = 1000;
    public static final int STATIC_VM_ID_START = 1000000;
    public static final int DYNAMIC_VM_ID_START = 1000000000;
    public static final Comparator<StateNode> vmIdComparator = new Comparator<StateNode>(){

        @Override
        public int compare(StateNode o1, StateNode o2) {
            return StateNode.vmIdOf(o1) - StateNode.vmIdOf(o2);
        }
    };
    public static final int NULL_TYPE_ID = -1;

    public final ObjVector<StateNode> getRefs() {
        ObjVector<StateNode> v = new ObjVector<StateNode>(0);
        this.addRefs(v);
        return v;
    }

    public abstract void addRefs(ObjVector<StateNode> var1);

    public abstract boolean refsOrdered();

    public final IntVector getPrimData() {
        IntVector v = new IntVector(0);
        this.addPrimData(v);
        return v;
    }

    public abstract void addPrimData(IntVector var1);

    public static int linearIdOf(StateNode n) {
        return n == null ? -1 : n.linearNodeId;
    }

    public static int vmIdOf(StateNode n) {
        return n == null ? -1 : n.vmNodeId;
    }

    public static int typeIdOf(StateNode n) {
        return n == null ? -1 : n.getNodeTypeId();
    }

    public final int getNodeTypeId() {
        return nodeTypes.poolIndex(this.getClass());
    }
}

