/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.jpf.jvm.abstraction.linearization;

import gov.nasa.jpf.jvm.abstraction.StateGraph;
import gov.nasa.jpf.jvm.abstraction.StateGraphLinearizer;
import gov.nasa.jpf.jvm.abstraction.state.StateNode;
import gov.nasa.jpf.util.ObjArray;
import gov.nasa.jpf.util.ObjVector;
import gov.nasa.jpf.util.ReadOnlyObjList;

public abstract class StateGraphLinearizerSkeleton
implements StateGraphLinearizer {
    private final ObjVector<StateNode> orderedNodes = new ObjVector();

    @Override
    public final void invalidateLinearization(StateGraph graph, ReadOnlyObjList<StateNode> nodeList) {
        for (StateNode node : nodeList) {
            node.linearNodeId = -2;
        }
    }

    @Override
    public final ReadOnlyObjList<StateNode> linearizeStateGraph(StateGraph graph) {
        this.linearizeFrom(graph.root);
        ObjArray<StateNode> ret = this.orderedNodes.toObjArray();
        this.orderedNodes.clear();
        return ret;
    }

    protected abstract void linearizeFrom(StateNode var1);

    protected final ReadOnlyObjList<StateNode> getOrderedNodes() {
        return this.orderedNodes;
    }

    protected final void maybeAdd(StateNode node) {
        if (node != null && node.linearNodeId == -2) {
            node.linearNodeId = this.orderedNodes.length();
            this.orderedNodes.add(node);
        }
    }
}

