/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.jpf.jvm.abstraction.linearization;

import gov.nasa.jpf.Config;
import gov.nasa.jpf.jvm.abstraction.linearization.NodeOrderingHeuristic;
import gov.nasa.jpf.jvm.abstraction.state.StateNode;
import gov.nasa.jpf.util.IntVector;
import gov.nasa.jpf.util.ObjVector;

public class DefaultNodeOrderingHeuristic
implements NodeOrderingHeuristic {
    protected int heuristicDepth;

    @Override
    public void init(Config config) throws Config.Exception {
        this.heuristicDepth = config.getInt("abstraction.linearization.heuristic_depth", 3);
    }

    @Override
    public final int compare(StateNode o1, StateNode o2) {
        return this.compare(o1, o2, this.heuristicDepth);
    }

    public int compare(StateNode o1, StateNode o2, int remainingDepth) {
        if (o1 == o2) {
            return 0;
        }
        int diff = StateNode.linearIdOf(o1) - StateNode.linearIdOf(o2);
        if (diff != 0) {
            return diff;
        }
        diff = o1.getNodeTypeId() - o2.getNodeTypeId();
        if (diff != 0) {
            return diff;
        }
        if (remainingDepth <= 0) {
            return 0;
        }
        IntVector prims1 = o1.getPrimData();
        IntVector prims2 = o2.getPrimData();
        diff = prims1.size() - prims2.size();
        if (diff != 0) {
            return diff;
        }
        diff = prims1.compareTo(prims2);
        if (diff != 0) {
            return diff;
        }
        diff = (o1.refsOrdered() ? 1 : 0) - (o2.refsOrdered() ? 1 : 0);
        if (diff != 0) {
            return diff;
        }
        ObjVector<StateNode> refs1 = o1.getRefs();
        ObjVector<StateNode> refs2 = o2.getRefs();
        diff = refs1.size() - refs2.size();
        if (diff != 0) {
            return diff;
        }
        if (o1.refsOrdered()) {
            int len = refs1.size();
            for (int i = 0; i < len; ++i) {
                diff = this.compare(refs1.get(i), refs2.get(i), remainingDepth - 1);
                if (diff == 0) continue;
                return diff;
            }
        } else {
            diff = this.compareUnordered(refs1, refs2);
            if (diff != 0) {
                return diff;
            }
        }
        return 0;
    }

    protected int compareUnordered(ObjVector<StateNode> refs1, ObjVector<StateNode> refs2) {
        int i;
        int len = refs1.size();
        int sum1 = 0;
        int sum2 = 0;
        for (i = 0; i < len; ++i) {
            sum1 += StateNode.linearIdOf(refs1.get(i));
            sum2 += StateNode.linearIdOf(refs2.get(i));
        }
        int diff = sum1 - sum2;
        if (diff != 0) {
            return diff;
        }
        sum1 = 0;
        sum2 = 0;
        for (i = 0; i < len; ++i) {
            sum1 += StateNode.typeIdOf(refs1.get(i));
            sum2 += StateNode.typeIdOf(refs2.get(i));
        }
        diff = sum1 - sum2;
        if (diff != 0) {
            return diff;
        }
        return 0;
    }
}

