/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.jpf.jvm.abstraction.filter;

import gov.nasa.jpf.Config;
import gov.nasa.jpf.jvm.AbstractSerializer;
import gov.nasa.jpf.jvm.ArrayFields;
import gov.nasa.jpf.jvm.ClassInfo;
import gov.nasa.jpf.jvm.DynamicElementInfo;
import gov.nasa.jpf.jvm.FieldInfo;
import gov.nasa.jpf.jvm.Fields;
import gov.nasa.jpf.jvm.JVM;
import gov.nasa.jpf.jvm.MethodInfo;
import gov.nasa.jpf.jvm.StackFrame;
import gov.nasa.jpf.jvm.StaticElementInfo;
import gov.nasa.jpf.jvm.ThreadInfo;
import gov.nasa.jpf.jvm.abstraction.filter.DefaultFilterConfiguration;
import gov.nasa.jpf.jvm.abstraction.filter.FilterConfiguration;
import gov.nasa.jpf.jvm.abstraction.filter.FramePolicy;
import gov.nasa.jpf.util.BitArray;
import gov.nasa.jpf.util.FinalBitSet;
import gov.nasa.jpf.util.IntVector;
import gov.nasa.jpf.util.Misc;
import gov.nasa.jpf.util.ObjVector;

public class SimpleFilteringSerializer
extends AbstractSerializer {
    protected FilterConfiguration filter;
    final ObjVector<FramePolicy> methodCache = new ObjVector();
    final ObjVector<FinalBitSet> instanceCache = new ObjVector();
    final ObjVector<FinalBitSet> staticCache = new ObjVector();
    protected transient IntVector buf = new IntVector(300);

    @Override
    public void attach(JVM jvm) throws Config.Exception {
        super.attach(jvm);
        this.filter = jvm.getConfig().getInstance("filter.class", FilterConfiguration.class);
        if (this.filter == null) {
            this.filter = new DefaultFilterConfiguration();
        }
        this.filter.init(jvm.getConfig());
    }

    FramePolicy getFramePolicy(MethodInfo mi) {
        int mid = mi.getGlobalId();
        FramePolicy p = this.methodCache.get(mid);
        if (p == null) {
            p = this.filter.getFramePolicy(mi);
            this.methodCache.set(mid, p);
        }
        return p;
    }

    FinalBitSet getIFields(ClassInfo ci) {
        int cid = ci.getUniqueId();
        FinalBitSet v = this.instanceCache.get(cid);
        if (v == null) {
            BitArray b = new BitArray(ci.getInstanceDataSize());
            b.setAll();
            for (FieldInfo fi : this.filter.getMatchedInstanceFields(ci)) {
                int start = fi.getStorageOffset();
                int end = start + fi.getStorageSize();
                for (int i = start; i < end; ++i) {
                    b.clear(i);
                }
            }
            v = FinalBitSet.create(b);
            if (v == null) {
                throw new IllegalStateException("Null BitArray returned.");
            }
            this.instanceCache.set(cid, v);
        }
        return v;
    }

    FinalBitSet getSFields(ClassInfo ci) {
        int cid = ci.getUniqueId();
        FinalBitSet v = this.staticCache.get(cid);
        if (v == null) {
            BitArray b = new BitArray(ci.getStaticDataSize());
            b.setAll();
            for (FieldInfo fi : this.filter.getMatchedStaticFields(ci)) {
                int start = fi.getStorageOffset();
                int end = start + fi.getStorageSize();
                for (int i = start; i < end; ++i) {
                    b.clear(i);
                }
            }
            v = FinalBitSet.create(b);
            if (v == null) {
                throw new IllegalStateException("Null BitArray returned.");
            }
            this.staticCache.set(cid, v);
        }
        return v;
    }

    @Override
    protected int[] computeStoringData() {
        int i;
        int max;
        FinalBitSet filtered;
        ClassInfo ci;
        this.buf.clear();
        this.buf.add(this.ks.tl.length());
        for (ThreadInfo t : this.ks.tl.getThreads()) {
            this.buf.add2(t.getThreadObjectRef(), t.getStatus());
            StackFrame[] frames = t.dumpStack();
            int frameCountPos = this.buf.size();
            this.buf.add(0);
            int frameCount = 0;
            for (StackFrame f : frames) {
                ++frameCount;
                MethodInfo mi = f.getMethodInfo();
                FramePolicy policy = this.getFramePolicy(mi);
                int pc = policy.includePC ? f.getPC().getOffset() : -1;
                this.buf.add2(mi.getGlobalId(), pc);
                int lenIdx = this.buf.size();
                this.buf.add(0);
                int len = 0;
                if (policy.includeLocals) {
                    int lcount = f.getLocalVariableCount();
                    len += lcount;
                    for (int i2 = 0; i2 < lcount; ++i2) {
                        this.buf.add(f.getLocalVariable(i2));
                    }
                }
                if (policy.includeOps) {
                    int ocount = f.getTopPos() + 1;
                    len += ocount;
                    for (int i2 = 0; i2 < ocount; ++i2) {
                        this.buf.add(f.getAbsOperand(i2));
                    }
                }
                this.buf.set(lenIdx, len);
                if (!policy.recurse) break;
            }
            this.buf.set(frameCountPos, frameCount);
        }
        this.buf.add(this.ks.da.getLength());
        for (DynamicElementInfo d : this.ks.da) {
            if (d == null) {
                this.buf.add(-1);
                continue;
            }
            Fields fields = d.getFields();
            ci = fields.getClassInfo();
            this.buf.add(ci.getUniqueId());
            if (fields instanceof ArrayFields) {
                int[] values = fields.dumpRawValues();
                this.buf.add(values.length);
                this.buf.append(values);
                continue;
            }
            filtered = this.getIFields(ci);
            max = ci.getInstanceDataSize();
            if (filtered == FinalBitSet.empty) {
                this.buf.append(fields.dumpRawValues());
                continue;
            }
            for (i = 0; i < max; ++i) {
                if (filtered.get(i)) continue;
                this.buf.add(fields.getIntValue(i));
            }
        }
        this.buf.add(this.ks.sa.getLength());
        for (StaticElementInfo s : Misc.iterableFromIterator(this.ks.sa.iterator())) {
            if (s == null) {
                this.buf.add(-1);
                continue;
            }
            this.buf.add(s.getStatus());
            Fields fields = s.getFields();
            ci = fields.getClassInfo();
            filtered = this.getSFields(ci);
            max = ci.getStaticDataSize();
            if (filtered == FinalBitSet.empty) {
                this.buf.append(fields.dumpRawValues());
                continue;
            }
            for (i = 0; i < max; ++i) {
                if (filtered.get(i)) continue;
                this.buf.add(fields.getIntValue(i));
            }
        }
        return this.buf.toArray();
    }
}

