/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.jpf.jvm.abstraction.filter;

import gov.nasa.jpf.jvm.FieldInfo;
import gov.nasa.jpf.jvm.abstraction.filter.AmmendableFilterConfiguration;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public class FieldAmmendmentByName
implements AmmendableFilterConfiguration.FieldAmmendment {
    protected final Set<String> fullFieldNames;
    protected final boolean policy;

    public FieldAmmendmentByName(String[] fieldNames, boolean policy) {
        this((Collection<String>)Arrays.asList(fieldNames), policy);
    }

    public FieldAmmendmentByName(Collection<String> fullFieldNames, boolean policy) {
        this.fullFieldNames = new HashSet<String>(fullFieldNames);
        this.policy = policy;
    }

    public FieldAmmendmentByName(Iterable<String> fullFieldNames, boolean policy) {
        this.fullFieldNames = new HashSet<String>();
        for (String name : fullFieldNames) {
            this.fullFieldNames.add(name);
        }
        this.policy = policy;
    }

    @Override
    public boolean ammendFieldInclusion(FieldInfo fi, boolean sofar) {
        if (this.fullFieldNames.contains(fi.getFullName())) {
            return this.policy;
        }
        return sofar;
    }
}

