/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.jpf.jvm.abstraction.abstractor;

import gov.nasa.jpf.jvm.StackFrame;
import gov.nasa.jpf.jvm.abstraction.abstractor.AbstractorProcess;
import gov.nasa.jpf.jvm.abstraction.abstractor.StackTailAbstractor;
import gov.nasa.jpf.jvm.abstraction.filter.FramePolicy;
import gov.nasa.jpf.jvm.abstraction.state.FrameNode;
import gov.nasa.jpf.jvm.abstraction.state.ThreadNode;

public final class StackTailAbstractors {
    public static final Default defaultInstance = new Default();
    public static final NoRecurse noRecurseInstance = new NoRecurse();

    private StackTailAbstractors() {
    }

    public static StackTailAbstractor fromPolicy(FramePolicy policy) {
        if (policy.recurse) {
            return defaultInstance;
        }
        return noRecurseInstance;
    }

    public static class NoRecurse
    extends Default {
        @Override
        protected void recurse(StackFrame[] frames, int fromIdx, ThreadNode threadNode, AbstractorProcess procInfo) {
        }
    }

    public static class Default
    implements StackTailAbstractor {
        @Override
        public void addFrames(StackFrame[] frames, int fromIdx, ThreadNode threadNode, AbstractorProcess procInfo) {
            if (fromIdx < frames.length) {
                StackFrame frame = frames[fromIdx];
                FrameNode node = procInfo.getFrameLocalAbstractor(frame.getMethodInfo()).getFrameNode(frame, procInfo);
                threadNode.frames.add(node);
                this.recurse(frames, fromIdx + 1, threadNode, procInfo);
            }
        }

        protected void recurse(StackFrame[] frames, int fromIdx, ThreadNode threadNode, AbstractorProcess procInfo) {
            if (fromIdx < frames.length) {
                procInfo.getStackTailAbstractor(frames[fromIdx].getMethodInfo()).addFrames(frames, fromIdx, threadNode, procInfo);
            }
        }
    }
}

