/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.jpf.jvm.abstraction.abstractor;

import gov.nasa.jpf.jvm.DynamicElementInfo;
import gov.nasa.jpf.jvm.FieldInfo;
import gov.nasa.jpf.jvm.Fields;
import gov.nasa.jpf.jvm.StaticElementInfo;
import gov.nasa.jpf.jvm.abstraction.abstractor.AbstractorProcess;
import gov.nasa.jpf.jvm.abstraction.abstractor.FieldsMetaBuilder;
import gov.nasa.jpf.jvm.abstraction.abstractor.ObjectAbstractor;
import gov.nasa.jpf.jvm.abstraction.abstractor.StaticsAbstractor;
import gov.nasa.jpf.jvm.abstraction.state.InstanceObject;
import gov.nasa.jpf.jvm.abstraction.state.NodeMetaData;
import gov.nasa.jpf.jvm.abstraction.state.ObjectNode;
import gov.nasa.jpf.jvm.abstraction.state.StaticsNode;
import gov.nasa.jpf.jvm.abstraction.state.ThreadObject;
import gov.nasa.jpf.util.IntVector;
import gov.nasa.jpf.util.ObjVector;

public class FieldsMeta
implements NodeMetaData {
    public final FieldInfo[] objFields;
    public final FieldInfo[] primFields;
    public final int nFields;

    public FieldsMeta(FieldsMetaBuilder builder) {
        this(builder.getObjs(), builder.getPrims(), builder.getNumberOfFields());
    }

    public FieldsMeta(FieldInfo[] objFields, FieldInfo[] primFields, int nFields) {
        this.objFields = objFields;
        this.primFields = primFields;
        this.nFields = nFields;
    }

    public int getNumberOfFields() {
        return this.nFields;
    }

    public int getNumberOfStorageInts() {
        return this.objFields.length + this.primFields.length;
    }

    public ObjVector<ObjectNode> getObjects(Fields values, AbstractorProcess procInfo) {
        int len = this.objFields.length;
        ObjVector<ObjectNode> refs = new ObjVector<ObjectNode>(len);
        for (int i = 0; i < len; ++i) {
            int objref = values.getReferenceValue(this.objFields[i].getStorageOffset());
            refs.add(procInfo.mapOldHeapRef(objref));
        }
        return refs;
    }

    public IntVector getPrims(Fields values) {
        int len = this.primFields.length;
        IntVector prims = new IntVector(len);
        int offset = -2;
        for (int i = 0; i < len; ++i) {
            FieldInfo fi = this.primFields[i];
            offset = fi == null ? ++offset : fi.getStorageOffset();
            prims.add(values.getIntValue(offset));
        }
        return prims;
    }

    public ObjectAbstractor<InstanceObject> getInstanceAbstractor() {
        return new InstanceAbstractor();
    }

    public ObjectAbstractor<ThreadObject> getThreadAbstractor() {
        return new ThreadAbstractor();
    }

    public StaticsAbstractor getStaticsAbstractor() {
        return new Statics();
    }

    protected class Statics
    implements StaticsAbstractor {
        protected Statics() {
        }

        @Override
        public StaticsNode getStaticsNode(StaticElementInfo sei, AbstractorProcess procInfo) {
            if (FieldsMeta.this.nFields == 0) {
                return null;
            }
            StaticsNode ret = new StaticsNode();
            Fields fields = sei.getFields();
            ret.refs = FieldsMeta.this.getObjects(fields, procInfo);
            ret.prims = FieldsMeta.this.getPrims(fields);
            ret.classId = sei.getClassInfo().getUniqueId();
            ret.meta = FieldsMeta.this;
            return ret;
        }
    }

    protected class ThreadAbstractor
    extends AbstractInstanceAbstractor<ThreadObject> {
        protected ThreadAbstractor() {
        }

        @Override
        public ThreadObject createInstanceSkeleton(DynamicElementInfo dei) {
            return new ThreadObject();
        }
    }

    protected class InstanceAbstractor
    extends AbstractInstanceAbstractor<InstanceObject> {
        protected InstanceAbstractor() {
        }

        @Override
        public InstanceObject createInstanceSkeleton(DynamicElementInfo dei) {
            return new InstanceObject();
        }
    }

    protected abstract class AbstractInstanceAbstractor<O extends InstanceObject>
    implements ObjectAbstractor<O> {
        protected AbstractInstanceAbstractor() {
        }

        @Override
        public void fillInstanceData(DynamicElementInfo dei, O skel, AbstractorProcess procInfo) {
            Fields fields = dei.getFields();
            ((InstanceObject)skel).refs = FieldsMeta.this.getObjects(fields, procInfo);
            ((InstanceObject)skel).prims = FieldsMeta.this.getPrims(fields);
            ((InstanceObject)skel).classId = dei.getClassInfo().getUniqueId();
            ((InstanceObject)skel).meta = FieldsMeta.this;
        }
    }
}

