/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.jpf.jvm.abstraction.abstractor;

import gov.nasa.jpf.Config;
import gov.nasa.jpf.jvm.ClassInfo;
import gov.nasa.jpf.jvm.JVM;
import gov.nasa.jpf.jvm.MethodInfo;
import gov.nasa.jpf.jvm.abstraction.abstractor.AbstractorConfiguration;
import gov.nasa.jpf.jvm.abstraction.abstractor.FrameLocalAbstractor;
import gov.nasa.jpf.jvm.abstraction.abstractor.ObjectAbstractor;
import gov.nasa.jpf.jvm.abstraction.abstractor.StackTailAbstractor;
import gov.nasa.jpf.jvm.abstraction.abstractor.StaticsAbstractor;
import gov.nasa.jpf.util.ObjVector;

public class CachedAbstractorConfiguration
implements AbstractorConfiguration {
    protected final AbstractorConfiguration config;
    protected final ObjVector<ObjectAbstractor<?>> objectCache = new ObjVector();
    protected final ObjVector<StaticsAbstractor> staticsCache = new ObjVector();
    protected final ObjVector<StackTailAbstractor> tailCache = new ObjVector();
    protected final ObjVector<FrameLocalAbstractor> frameCache = new ObjVector();

    public CachedAbstractorConfiguration(AbstractorConfiguration config) {
        this.config = config;
    }

    @Override
    public void attach(JVM jvm) throws Config.Exception {
        this.config.attach(jvm);
    }

    @Override
    public ObjectAbstractor<?> getObjectAbstractor(ClassInfo ci) {
        int cid = ci.getUniqueId();
        ObjectAbstractor<?> a = this.objectCache.get(cid);
        if (a == null) {
            a = this.config.getObjectAbstractor(ci);
            this.objectCache.set(cid, a);
        }
        return a;
    }

    @Override
    public StaticsAbstractor getStaticsAbstractor(ClassInfo ci) {
        int cid = ci.getUniqueId();
        StaticsAbstractor a = this.staticsCache.get(cid);
        if (a == null) {
            a = this.config.getStaticsAbstractor(ci);
            this.staticsCache.set(cid, a);
        }
        return a;
    }

    @Override
    public StackTailAbstractor getStackTailAbstractor(MethodInfo mi) {
        int mid = mi.getGlobalId();
        StackTailAbstractor a = this.tailCache.get(mid);
        if (a == null) {
            a = this.config.getStackTailAbstractor(mi);
            this.tailCache.set(mid, a);
        }
        return a;
    }

    @Override
    public FrameLocalAbstractor getFrameLocalAbstractor(MethodInfo mi) {
        int mid = mi.getGlobalId();
        FrameLocalAbstractor a = this.frameCache.get(mid);
        if (a == null) {
            a = this.config.getFrameLocalAbstractor(mi);
            this.frameCache.set(mid, a);
        }
        return a;
    }
}

