/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.jpf.jvm.abstraction;

import gov.nasa.jpf.Config;
import gov.nasa.jpf.jvm.AbstractSerializer;
import gov.nasa.jpf.jvm.JVM;
import gov.nasa.jpf.jvm.abstraction.DefaultStateGraphSerializer;
import gov.nasa.jpf.jvm.abstraction.StateGraph;
import gov.nasa.jpf.jvm.abstraction.StateGraphBuilder;
import gov.nasa.jpf.jvm.abstraction.StateGraphSerializer;
import gov.nasa.jpf.jvm.abstraction.StateGraphTransform;
import gov.nasa.jpf.jvm.abstraction.abstractor.AbstractorBasedBuilder;
import gov.nasa.jpf.util.ObjArray;
import java.util.LinkedList;

public class AbstractingSerializer
extends AbstractSerializer {
    protected StateGraphBuilder builder;
    protected LinkedList<StateGraphTransform> transforms = new LinkedList();
    protected StateGraphSerializer serializer;
    protected boolean started = false;

    @Override
    public void attach(JVM jvm) throws Config.Exception {
        super.attach(jvm);
        Config config = jvm.getConfig();
        this.builder = config.getInstance("abstraction.builder.class", StateGraphBuilder.class);
        if (this.builder == null) {
            this.builder = new AbstractorBasedBuilder();
        }
        this.builder.attach(jvm);
        ObjArray<StateGraphTransform> configTransforms = config.getInstances("abstraction.transforms", StateGraphTransform.class);
        if (configTransforms != null) {
            for (StateGraphTransform t : configTransforms) {
                this.transforms.addLast(t);
                t.init(config);
            }
        }
        this.serializer = config.getInstance("abstraction.serializer.class", StateGraphSerializer.class);
        if (this.serializer == null) {
            this.serializer = new DefaultStateGraphSerializer();
        }
        this.serializer.init(config);
    }

    public void appendTransform(StateGraphTransform t) {
        assert (!this.started) : "Attempt to change abstraction after state matching has started.";
        this.transforms.addLast(t);
    }

    @Override
    protected int[] computeStoringData() {
        this.started = true;
        StateGraph g = this.builder.buildStateGraph();
        for (StateGraphTransform transform : this.transforms) {
            transform.transformStateGraph(g);
        }
        return this.serializer.serializeStateGraph(g);
    }
}

