/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.jpf.jvm;

import gov.nasa.jpf.jvm.JVM;
import gov.nasa.jpf.jvm.VMListener;

public class VMListenerMulticaster
implements VMListener {
    VMListener head;
    VMListener tail;

    public static VMListener add(VMListener oldListener, VMListener newListener) {
        if (newListener == null) {
            return oldListener;
        }
        if (oldListener == null) {
            return newListener;
        }
        if (newListener == oldListener) {
            return oldListener;
        }
        if (oldListener instanceof VMListenerMulticaster) {
            VMListenerMulticaster c = (VMListenerMulticaster)oldListener;
            while (c != null) {
                if (c.tail == newListener) {
                    return oldListener;
                }
                if (c.head == newListener) {
                    return oldListener;
                }
                if (!(c.head instanceof VMListenerMulticaster)) break;
                c = (VMListenerMulticaster)c.head;
            }
        }
        return new VMListenerMulticaster(oldListener, newListener);
    }

    public static boolean containsType(VMListener listener, Class<?> type) {
        if (listener == null) {
            return false;
        }
        if (listener instanceof VMListenerMulticaster) {
            VMListenerMulticaster l = (VMListenerMulticaster)listener;
            while (l != null) {
                if (type.isAssignableFrom(l.tail.getClass())) {
                    return true;
                }
                if (l.head instanceof VMListenerMulticaster) {
                    l = (VMListenerMulticaster)l.head;
                    continue;
                }
                return type.isAssignableFrom(l.head.getClass());
            }
            return false;
        }
        return type.isAssignableFrom(listener.getClass());
    }

    public static VMListener remove(VMListener oldListener, VMListener removeListener) {
        if (oldListener == removeListener) {
            return null;
        }
        if (oldListener instanceof VMListenerMulticaster) {
            return ((VMListenerMulticaster)oldListener).remove(removeListener);
        }
        return oldListener;
    }

    protected VMListener remove(VMListener listener) {
        if (listener == this.head) {
            return this.tail;
        }
        if (listener == this.tail) {
            return this.head;
        }
        if (this.head instanceof VMListenerMulticaster) {
            VMListenerMulticaster h = (VMListenerMulticaster)this.head;
            if (this.tail instanceof VMListenerMulticaster) {
                VMListenerMulticaster t = (VMListenerMulticaster)this.tail;
                return new VMListenerMulticaster(h.remove(listener), t.remove(listener));
            }
            return new VMListenerMulticaster(h.remove(listener), this.tail);
        }
        if (this.tail instanceof VMListenerMulticaster) {
            VMListenerMulticaster t = (VMListenerMulticaster)this.tail;
            return new VMListenerMulticaster(this.head, t.remove(listener));
        }
        return this;
    }

    public VMListenerMulticaster(VMListener h, VMListener t) {
        this.head = h;
        this.tail = t;
    }

    @Override
    public void executeInstruction(JVM vm) {
        this.head.executeInstruction(vm);
        this.tail.executeInstruction(vm);
    }

    @Override
    public void instructionExecuted(JVM vm) {
        this.head.instructionExecuted(vm);
        this.tail.instructionExecuted(vm);
    }

    @Override
    public void threadStarted(JVM vm) {
        this.head.threadStarted(vm);
        this.tail.threadStarted(vm);
    }

    @Override
    public void threadWaiting(JVM vm) {
        this.head.threadWaiting(vm);
        this.tail.threadWaiting(vm);
    }

    @Override
    public void threadNotified(JVM vm) {
        this.head.threadNotified(vm);
        this.tail.threadNotified(vm);
    }

    @Override
    public void threadInterrupted(JVM vm) {
        this.head.threadInterrupted(vm);
        this.tail.threadInterrupted(vm);
    }

    @Override
    public void threadBlocked(JVM vm) {
        this.head.threadBlocked(vm);
        this.tail.threadBlocked(vm);
    }

    @Override
    public void threadTerminated(JVM vm) {
        this.head.threadTerminated(vm);
        this.tail.threadTerminated(vm);
    }

    @Override
    public void threadScheduled(JVM vm) {
        this.head.threadScheduled(vm);
        this.tail.threadScheduled(vm);
    }

    @Override
    public void classLoaded(JVM vm) {
        this.head.classLoaded(vm);
        this.tail.classLoaded(vm);
    }

    @Override
    public void objectCreated(JVM vm) {
        this.head.objectCreated(vm);
        this.tail.objectCreated(vm);
    }

    @Override
    public void objectReleased(JVM vm) {
        this.head.objectReleased(vm);
        this.tail.objectReleased(vm);
    }

    @Override
    public void gcBegin(JVM vm) {
        this.head.gcBegin(vm);
        this.tail.gcBegin(vm);
    }

    @Override
    public void gcEnd(JVM vm) {
        this.head.gcEnd(vm);
        this.tail.gcEnd(vm);
    }

    @Override
    public void exceptionThrown(JVM vm) {
        this.head.exceptionThrown(vm);
        this.tail.exceptionThrown(vm);
    }

    @Override
    public void objectLocked(JVM vm) {
        this.head.objectLocked(vm);
        this.tail.objectLocked(vm);
    }

    @Override
    public void objectUnlocked(JVM vm) {
        this.head.objectUnlocked(vm);
        this.tail.objectUnlocked(vm);
    }

    @Override
    public void objectWait(JVM vm) {
        this.head.objectWait(vm);
        this.tail.objectWait(vm);
    }

    @Override
    public void objectNotify(JVM vm) {
        this.head.objectNotify(vm);
        this.tail.objectNotify(vm);
    }

    @Override
    public void objectNotifyAll(JVM vm) {
        this.head.objectNotifyAll(vm);
        this.tail.objectNotifyAll(vm);
    }

    @Override
    public void choiceGeneratorSet(JVM vm) {
        this.head.choiceGeneratorSet(vm);
        this.tail.choiceGeneratorSet(vm);
    }

    @Override
    public void choiceGeneratorAdvanced(JVM vm) {
        this.head.choiceGeneratorAdvanced(vm);
        this.tail.choiceGeneratorAdvanced(vm);
    }

    @Override
    public void choiceGeneratorProcessed(JVM vm) {
        this.head.choiceGeneratorProcessed(vm);
        this.tail.choiceGeneratorProcessed(vm);
    }
}

