/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.jpf.jvm;

import gov.nasa.jpf.jvm.DynamicArea;
import gov.nasa.jpf.jvm.ElementInfo;
import gov.nasa.jpf.jvm.ThreadInfo;
import gov.nasa.jpf.util.Printable;
import java.io.PrintWriter;

public class UncaughtException
extends RuntimeException
implements Printable {
    ThreadInfo thread;
    int xObjRef;
    String xClsName;
    String details;

    public UncaughtException(ThreadInfo ti, int objRef) {
        this.thread = ti;
        this.xObjRef = objRef;
        Object ei = DynamicArea.getHeap().get(this.xObjRef);
        this.xClsName = ((ElementInfo)ei).getClassInfo().getName();
        this.details = ((ElementInfo)ei).getStringField("detailMessage");
    }

    public String getRawMessage() {
        return this.xClsName;
    }

    @Override
    public String getMessage() {
        String s = "uncaught exception in thread " + this.thread.getName() + " #" + this.thread.getIndex() + " : " + this.xClsName;
        if (this.details != null) {
            s = s + " : \"" + this.details + "\"";
        }
        return s;
    }

    @Override
    public void printOn(PrintWriter pw) {
        pw.print("uncaught exception in thread ");
        pw.print(this.thread.getName());
        pw.print(" #");
        pw.print(this.thread.index);
        pw.print(" : ");
        this.thread.printStackTrace(pw, this.xObjRef);
        pw.flush();
    }
}

