/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.jpf.jvm;

import gov.nasa.jpf.jvm.ChoiceGenerator;
import gov.nasa.jpf.jvm.Step;
import gov.nasa.jpf.jvm.ThreadInfo;
import java.util.Iterator;

public class Transition
implements Iterable<Step> {
    ChoiceGenerator<?> cg;
    ThreadInfo ti;
    private Step first;
    private Step last;
    int nSteps;
    private Object annotation;
    String output;

    public Transition(ChoiceGenerator<?> cg, ThreadInfo ti) {
        this.cg = cg;
        this.ti = ti;
    }

    public String getLabel() {
        if (this.last != null) {
            return this.last.getLineString();
        }
        return "?";
    }

    public void setOutput(String s) {
        this.output = s;
    }

    public void setAnnotation(Object o) {
        this.annotation = o;
    }

    public Object getAnnotation() {
        return this.annotation;
    }

    public String getOutput() {
        return this.output;
    }

    public Step getStep(int index) {
        Step s = this.first;
        for (int i = 0; s != null && i < index; ++i) {
            s = s.next;
        }
        return s;
    }

    public Step getLastStep() {
        return this.last;
    }

    public int getStepCount() {
        return this.nSteps;
    }

    public int getThreadIndex() {
        return this.ti.getIndex();
    }

    public ChoiceGenerator getChoiceGenerator() {
        return this.cg;
    }

    public void incStepCount() {
        ++this.nSteps;
    }

    void addStep(Step step) {
        if (this.first == null) {
            this.first = step;
            this.last = step;
        } else {
            this.last.next = step;
            this.last = step;
        }
        ++this.nSteps;
    }

    @Override
    public Iterator<Step> iterator() {
        return new StepIterator();
    }

    public class StepIterator
    implements Iterator<Step> {
        Step cur;

        @Override
        public boolean hasNext() {
            return this.cur != Transition.this.last;
        }

        @Override
        public Step next() {
            if (this.cur == null) {
                this.cur = Transition.this.first;
            } else if (this.cur != Transition.this.last) {
                this.cur = this.cur.next;
            } else {
                return null;
            }
            return this.cur;
        }

        @Override
        public void remove() {
            if (this.cur == null) {
                Transition.this.first = ((Transition)Transition.this).first.next;
            } else {
                Step s = Transition.this.first;
                while (s.next != this.cur) {
                    s = s.next;
                }
                s.next = this.cur.next;
                this.cur = this.cur.next;
            }
        }
    }
}

