/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.jpf.jvm;

import gov.nasa.jpf.Config;
import gov.nasa.jpf.jvm.KernelState;
import gov.nasa.jpf.jvm.ThreadInfo;
import java.util.BitSet;

public class ThreadList
implements Cloneable {
    private ThreadInfo[] threads;
    public KernelState ks;

    private ThreadList() {
    }

    public ThreadList(Config config, KernelState ks) {
        this.ks = ks;
        this.threads = new ThreadInfo[0];
    }

    public Object clone() {
        ThreadList other = new ThreadList();
        other.ks = this.ks;
        other.threads = new ThreadInfo[this.threads.length];
        for (int i = 0; i < this.threads.length; ++i) {
            other.threads[i] = (ThreadInfo)this.threads[i].clone();
        }
        return other;
    }

    public int add(ThreadInfo ti) {
        int n = this.threads.length;
        for (ThreadInfo t : this.threads) {
            if (t != ti) continue;
            return t.getIndex();
        }
        ThreadInfo[] newList = new ThreadInfo[n + 1];
        System.arraycopy(this.threads, 0, newList, 0, n);
        newList[n] = ti;
        this.threads = newList;
        return n;
    }

    public boolean hasAnyAliveThread() {
        int l = this.threads.length;
        for (int i = 0; i < l; ++i) {
            if (!this.threads[i].isAlive()) continue;
            return true;
        }
        return false;
    }

    public ThreadInfo[] getThreads() {
        return (ThreadInfo[])this.threads.clone();
    }

    public ThreadInfo get(int index) {
        return this.threads[index];
    }

    public int length() {
        return this.threads.length;
    }

    public void setAll(ThreadInfo[] threads) {
        this.threads = threads;
    }

    public ThreadInfo locate(int objref) {
        int l = this.threads.length;
        for (int i = 0; i < l; ++i) {
            if (this.threads[i].getThreadObjectRef() != objref) continue;
            return this.threads[i];
        }
        return null;
    }

    public void markRoots() {
        int l = this.threads.length;
        for (int i = 0; i < l; ++i) {
            if (!this.threads[i].isAlive()) continue;
            this.threads[i].markRoots();
        }
    }

    public boolean hasMoreThreadsToRun() {
        int nonDaemons = 0;
        int runnables = 0;
        for (int i = 0; i < this.threads.length; ++i) {
            ThreadInfo ti = this.threads[i];
            if (!ti.isDaemon() && !ti.isTerminated()) {
                ++nonDaemons;
            }
            if (!ti.isTimeoutRunnable()) continue;
            ++runnables;
        }
        return nonDaemons > 0 && runnables > 0;
    }

    public int getNonDaemonThreadCount() {
        int nd = 0;
        for (int i = 0; i < this.threads.length; ++i) {
            if (this.threads[i].isDaemon()) continue;
            ++nd;
        }
        return nd;
    }

    public int getRunnableThreadCount() {
        int n = 0;
        for (int i = 0; i < this.threads.length; ++i) {
            if (!this.threads[i].isTimeoutRunnable()) continue;
            ++n;
        }
        return n;
    }

    public ThreadInfo[] getRunnableThreads() {
        int nRunnable = this.getRunnableThreadCount();
        ThreadInfo[] list = new ThreadInfo[nRunnable];
        int j = 0;
        for (int i = 0; i < this.threads.length; ++i) {
            if (!this.threads[i].isTimeoutRunnable()) continue;
            list[j++] = this.threads[i];
            if (j == nRunnable) break;
        }
        return list;
    }

    public ThreadInfo[] getRunnableThreadsWith(ThreadInfo ti) {
        int nRunnable = this.getRunnableThreadCount();
        ThreadInfo[] list = new ThreadInfo[ti.isRunnable() ? nRunnable : nRunnable + 1];
        int j = 0;
        for (int i = 0; i < this.threads.length; ++i) {
            if (!this.threads[i].isTimeoutRunnable() && this.threads[i] != ti) continue;
            list[j++] = this.threads[i];
            if (j == list.length) break;
        }
        return list;
    }

    public ThreadInfo[] getRunnableThreadsWithout(ThreadInfo ti) {
        int nRunnable = this.getRunnableThreadCount();
        if (ti.isRunnable()) {
            --nRunnable;
        }
        ThreadInfo[] list = new ThreadInfo[nRunnable];
        int j = 0;
        for (int i = 0; i < this.threads.length; ++i) {
            if (!this.threads[i].isTimeoutRunnable() || ti == this.threads[i]) continue;
            list[j++] = this.threads[i];
            if (j == nRunnable) break;
        }
        return list;
    }

    public int getLiveThreadCount() {
        int n = 0;
        for (int i = 0; i < this.threads.length; ++i) {
            if (!this.threads[i].isAlive()) continue;
            ++n;
        }
        return n;
    }

    boolean hasOtherRunnablesThan(ThreadInfo ti) {
        int n = this.threads.length;
        for (int i = 0; i < n; ++i) {
            if (this.threads[i] == ti || !this.threads[i].isRunnable()) continue;
            return true;
        }
        return false;
    }

    boolean isDeadlocked() {
        boolean hasBlockedThreads = false;
        for (int i = 0; i < this.threads.length; ++i) {
            ThreadInfo ti = this.threads[i];
            if (ti.isTimeoutRunnable()) {
                return false;
            }
            if (!ti.isAlive()) continue;
            hasBlockedThreads = true;
        }
        return hasBlockedThreads;
    }

    public void sweepTerminated(BitSet isUsed) {
    }

    public void dump() {
        int i = 0;
        for (ThreadInfo t : this.threads) {
            System.err.println("[" + i++ + "] " + t);
        }
    }
}

