/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.jpf.jvm;

import gov.nasa.jpf.Config;
import gov.nasa.jpf.JPFException;
import gov.nasa.jpf.jvm.ChoiceGenerator;
import gov.nasa.jpf.jvm.ChoicePoint;
import gov.nasa.jpf.jvm.ElementInfo;
import gov.nasa.jpf.jvm.JVM;
import gov.nasa.jpf.jvm.KernelState;
import gov.nasa.jpf.jvm.MethodInfo;
import gov.nasa.jpf.jvm.SchedulerFactory;
import gov.nasa.jpf.jvm.Step;
import gov.nasa.jpf.jvm.ThreadChoiceGenerator;
import gov.nasa.jpf.jvm.ThreadInfo;
import gov.nasa.jpf.jvm.Transition;
import gov.nasa.jpf.jvm.UncaughtException;
import gov.nasa.jpf.jvm.bytecode.Instruction;
import gov.nasa.jpf.util.HashData;
import java.io.PrintWriter;

public class SystemState {
    int id;
    ChoiceGenerator<?> nextCg;
    ChoiceGenerator<?> curCg;
    ThreadInfo execThread;
    public KernelState ks;
    public Transition trail;
    boolean retainAttributes;
    boolean isIgnored;
    boolean isForced;
    boolean isInteresting;
    boolean isBoring;
    boolean isBlockedInAtomicSection;
    public UncaughtException uncaughtException;
    boolean GCNeeded = false;
    int maxAllocPerGC;
    int nAlloc;
    int atomicLevel;
    int entryAtomicLevel;
    SchedulerFactory schedulerFactory;
    boolean randomizeChoices;
    boolean recordSteps;

    public SystemState(Config config, JVM vm) throws Config.Exception {
        this.ks = new KernelState(config);
        this.id = -1;
        Class[] argTypes = new Class[]{Config.class, JVM.class, SystemState.class};
        Object[] args = new Object[]{config, vm, this};
        this.schedulerFactory = config.getEssentialInstance("vm.scheduler_factory.class", SchedulerFactory.class, argTypes, args);
        this.randomizeChoices = config.getBoolean("cg.randomize_choices", false);
        this.maxAllocPerGC = config.getInt("vm.max_alloc_gc", Integer.MAX_VALUE);
    }

    public void setStartThread(ThreadInfo ti) {
        this.execThread = ti;
        this.trail = new Transition(this.nextCg, this.execThread);
    }

    public ChoiceGenerator<?>[] getChoiceGenerators() {
        ChoiceGenerator<?> cg = this.curCg;
        int n = 0;
        while (cg != null) {
            cg = cg.getPreviousChoiceGenerator();
            ++n;
        }
        ChoiceGenerator[] list = new ChoiceGenerator[n];
        cg = this.curCg;
        int i = list.length - 1;
        while (cg != null) {
            list[i] = cg;
            cg = cg.getPreviousChoiceGenerator();
            --i;
        }
        return list;
    }

    public int getId() {
        return this.id;
    }

    void setId(int newId) {
        this.id = newId;
    }

    public void recordSteps(boolean cond) {
        this.recordSteps = cond;
    }

    public void incAtomic() {
        ++this.atomicLevel;
    }

    public void decAtomic() {
        if (this.atomicLevel > 0) {
            --this.atomicLevel;
        }
    }

    public void clearAtomic() {
        this.atomicLevel = 0;
    }

    public boolean isAtomic() {
        return this.atomicLevel > 0;
    }

    public void setBlockedInAtomicSection() {
        this.isBlockedInAtomicSection = true;
    }

    public Transition getTrail() {
        return this.trail;
    }

    public SchedulerFactory getSchedulerFactory() {
        return this.schedulerFactory;
    }

    public ChoiceGenerator<?> getChoiceGenerator() {
        return this.curCg;
    }

    public <T extends ChoiceGenerator<?>> T getLastChoiceGeneratorOfType(Class<T> cgType) {
        ChoiceGenerator<?> cg;
        for (cg = this.curCg; cg != null && !cgType.isAssignableFrom(cg.getClass()); cg = cg.getPreviousChoiceGenerator()) {
        }
        return (T)cg;
    }

    public ChoiceGenerator<?> getNextChoiceGenerator() {
        return this.nextCg;
    }

    public void setNextChoiceGenerator(ChoiceGenerator<?> cg) {
        this.nextCg = this.randomizeChoices ? cg.randomize() : cg;
        this.nextCg.setPreviousChoiceGenerator(this.curCg);
        ThreadInfo ti = ThreadInfo.getCurrentThread();
        this.nextCg.setThreadInfo(ti);
        this.nextCg.setInsn(ti.getPC());
    }

    public Object getBacktrackData() {
        return new Memento(this);
    }

    public void backtrackTo(Object backtrackData) {
        ((Memento)backtrackData).backtrack(this);
    }

    public void restoreTo(Object backtrackData) {
        ((Memento)backtrackData).restore(this);
    }

    public void retainAttributes(boolean b) {
        this.retainAttributes = b;
    }

    public boolean getRetainAttributes() {
        return this.retainAttributes;
    }

    public void setIgnored(boolean b) {
        if (this.nextCg != null) {
            this.nextCg = null;
        }
        this.isIgnored = b;
        if (b) {
            this.isForced = false;
        }
    }

    public boolean isIgnored() {
        return this.isIgnored;
    }

    public void setForced(boolean b) {
        this.isForced = b;
        if (b) {
            this.isIgnored = false;
        }
    }

    public boolean isForced() {
        return this.isForced;
    }

    public void setInteresting(boolean b) {
        this.isInteresting = b;
        if (b) {
            this.isBoring = false;
        }
    }

    public boolean isInteresting() {
        return this.isInteresting;
    }

    public void setBoring(boolean b) {
        this.isBoring = b;
        if (b) {
            this.isInteresting = false;
        }
    }

    public boolean isBoring() {
        return this.isBoring;
    }

    public boolean isInitState() {
        return this.id == -1;
    }

    public int getNonDaemonThreadCount() {
        return this.ks.tl.getNonDaemonThreadCount();
    }

    public ElementInfo getObject(int reference) {
        return this.ks.da.get(reference);
    }

    @Deprecated
    public ThreadInfo getThread(int index) {
        return this.ks.tl.get(index);
    }

    @Deprecated
    public ThreadInfo getThread(ElementInfo reference) {
        return this.getThread(reference.getIndex());
    }

    public int getThreadCount() {
        return this.ks.tl.length();
    }

    public int getRunnableThreadCount() {
        return this.ks.tl.getRunnableThreadCount();
    }

    public int getLiveThreadCount() {
        return this.ks.tl.getLiveThreadCount();
    }

    public ThreadInfo getThreadInfo(int idx) {
        return this.ks.tl.get(idx);
    }

    boolean isDeadlocked() {
        if (this.isBlockedInAtomicSection) {
            return true;
        }
        return this.ks.isDeadlocked();
    }

    public UncaughtException getUncaughtException() {
        return this.uncaughtException;
    }

    public void activateGC() {
        this.GCNeeded = true;
    }

    public void gcIfNeeded() {
        if (this.GCNeeded) {
            this.ks.gc();
            this.GCNeeded = false;
        }
        this.nAlloc = 0;
    }

    public void checkGC() {
        if (this.nAlloc++ > this.maxAllocPerGC) {
            this.gcIfNeeded();
        }
    }

    public void hash(HashData hd) {
        this.ks.hash(hd);
    }

    void dumpThreadCG(ThreadChoiceGenerator cg) {
        PrintWriter pw = new PrintWriter(System.out, true);
        cg.printOn(pw);
        pw.flush();
    }

    public boolean nextSuccessor(JVM vm) throws JPFException {
        ThreadChoiceGenerator tcg;
        if (!this.retainAttributes) {
            this.isIgnored = false;
            this.isForced = false;
            this.isInteresting = false;
            this.isBoring = false;
        }
        if (this.nextCg != null) {
            this.curCg = this.nextCg;
            this.nextCg = null;
            vm.notifyChoiceGeneratorSet(this.curCg);
        }
        assert (this.curCg != null) : "transition without choice generator";
        do {
            if (!this.curCg.hasMoreChoices()) {
                vm.notifyChoiceGeneratorProcessed(this.curCg);
                return false;
            }
            this.curCg.advance();
            this.isIgnored = false;
            vm.notifyChoiceGeneratorAdvanced(this.curCg);
        } while (this.isIgnored);
        if (this.curCg instanceof ThreadChoiceGenerator && (tcg = (ThreadChoiceGenerator)this.curCg).isSchedulingPoint()) {
            this.execThread = tcg.getNextChoice();
            vm.notifyThreadScheduled(this.execThread);
        }
        this.trail = new Transition(this.curCg, this.execThread);
        this.entryAtomicLevel = this.atomicLevel;
        this.execThread.executeStep(this);
        return true;
    }

    boolean breakTransition() {
        return this.nextCg != null || this.isIgnored;
    }

    void recordExecutionStep(MethodInfo mth, Instruction pc) {
        if (this.recordSteps) {
            String src = mth.getSourceFileName();
            Step step = new Step(src, mth.getLineNumber(pc), pc);
            this.trail.addStep(step);
        } else {
            this.trail.incStepCount();
        }
    }

    public boolean isEndState() {
        return this.ks.isTerminated();
    }

    static class Memento {
        ChoiceGenerator<?> curCg;
        ChoiceGenerator<?> nextCg;
        int atomicLevel;
        ChoicePoint trace;
        ThreadInfo execThread;
        int id;

        Memento(SystemState ss) {
            this.nextCg = ss.nextCg;
            this.curCg = ss.curCg;
            this.atomicLevel = ss.entryAtomicLevel;
            this.id = ss.id;
            this.execThread = ss.execThread;
        }

        void backtrack(SystemState ss) {
            ss.nextCg = null;
            ss.curCg = this.curCg;
            ss.atomicLevel = this.atomicLevel;
            ss.id = this.id;
            ss.execThread = this.execThread;
        }

        void restore(SystemState ss) {
            ss.nextCg = this.nextCg;
            ss.curCg = this.curCg;
            ss.atomicLevel = this.atomicLevel;
            ss.id = this.id;
            ss.execThread = this.execThread;
        }
    }
}

