/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.jpf.jvm;

import gov.nasa.jpf.JPF;
import gov.nasa.jpf.jvm.ClassInfo;
import gov.nasa.jpf.jvm.DynamicArea;
import gov.nasa.jpf.jvm.ElementInfo;
import gov.nasa.jpf.jvm.FieldInfo;
import gov.nasa.jpf.jvm.FieldLockInfo;
import gov.nasa.jpf.jvm.SingleFieldLockInfo;
import gov.nasa.jpf.jvm.ThreadInfo;
import java.util.LinkedList;
import java.util.logging.Logger;

public class StatisticFieldLockInfo
extends FieldLockInfo {
    static Logger log = JPF.getLogger("gov.nasa.jpf.jvm.FieldLockInfo");
    static final int CHECK_THRESHOLD = 5;
    int[] lset;
    int checkLevel;

    static void appendLockSet(StringBuilder sb, int[] lockSet) {
        DynamicArea heap = DynamicArea.getHeap();
        if (lockSet == null || lockSet.length == 0) {
            sb.append("{}");
        } else {
            sb.append('{');
            int i = 0;
            while (i < lockSet.length) {
                int ref = lockSet[i];
                if (ref != -1) {
                    Object ei = heap.get(ref);
                    if (ei != null) {
                        sb.append(ei);
                    } else {
                        sb.append("?@");
                        sb.append(lockSet[i]);
                    }
                }
                if (++i >= lockSet.length) continue;
                sb.append(',');
            }
            sb.append('}');
        }
    }

    void lockAssumptionFailed(ElementInfo ei, FieldInfo fi, ThreadInfo ti) {
        String src = ti.getMethod().getClassInfo().getSourceFileName();
        int line = ti.getLine();
        StringBuilder sb = new StringBuilder("unprotected field access of: ");
        sb.append(ei);
        sb.append('.');
        sb.append(fi.getName());
        sb.append(" in thread: ");
        sb.append(ti.getName());
        sb.append(" (");
        sb.append(src);
        sb.append(':');
        sb.append(line);
        sb.append(")\nlock candidates: ");
        StatisticFieldLockInfo.appendLockSet(sb, this.lset);
        sb.append(", current locks: ");
        StatisticFieldLockInfo.appendLockSet(sb, ti.getLockedObjectReferences());
        sb.append("\n >>> re-run with 'vm.por.sync_detection=false' or exclude field from checks <<<");
        log.severe(sb.toString());
    }

    static ElementInfo strongProtectionCandidate(ElementInfo ei, FieldInfo fi, ThreadInfo ti) {
        LinkedList<ElementInfo> currentLocks = ti.getLockedObjects();
        int n = currentLocks.size();
        if (fi.isStatic()) {
            ClassInfo ci = fi.getClassInfo();
            int cref = ci.getClassObjectRef();
            for (int i = 0; i < n; ++i) {
                ElementInfo e = (ElementInfo)currentLocks.get(i);
                if (e.getIndex() != cref) continue;
                log.info("sync-detection: " + ei + " assumed to be synced on class object: " + e);
                return e;
            }
        } else {
            for (int i = 0; i < n; ++i) {
                ElementInfo e = (ElementInfo)currentLocks.get(i);
                int eidx = e.getIndex();
                if (ei == e) {
                    log.info("sync-detection: " + ei + " assumed to be synced on itself");
                    return e;
                }
                if (e.hasRefField(ei.getIndex())) {
                    log.info("sync-detection: " + ei + " assumed to be synced on object wrapper: " + e);
                    return e;
                }
                if (!ei.hasRefField(eidx)) continue;
                log.info("sync-detection: " + ei + " assumed to be synced on sibling: " + e);
                return e;
            }
        }
        return null;
    }

    @Override
    public FieldLockInfo checkProtection(ElementInfo ei, FieldInfo fi, ThreadInfo ti) {
        LinkedList<ElementInfo> currentLocks = ti.getLockedObjects();
        int nLocks = currentLocks.size();
        ++this.checkLevel;
        if (this.checkLevel == 1) {
            if (nLocks == 0) {
                return empty;
            }
            ElementInfo lcei = StatisticFieldLockInfo.strongProtectionCandidate(ei, fi, ti);
            if (lcei != null) {
                this.checkLevel = 5;
            }
            if (nLocks == 1) {
                return new SingleFieldLockInfo(((ElementInfo)currentLocks.get(0)).getIndex(), this.checkLevel);
            }
            this.lset = new int[nLocks];
            for (int i = 0; i < nLocks; ++i) {
                ElementInfo lei = (ElementInfo)currentLocks.get(i);
                this.lset[i] = lei.getIndex();
            }
        } else {
            if (nLocks == 0) {
                this.lockAssumptionFailed(ei, fi, ti);
                return empty;
            }
            int l = 0;
            int[] newLset = new int[this.lset.length];
            block1: for (int i = 0; i < nLocks; ++i) {
                ElementInfo lei = (ElementInfo)currentLocks.get(i);
                int leidx = lei.getIndex();
                for (int j = 0; j < this.lset.length; ++j) {
                    if (this.lset[j] != leidx) continue;
                    newLset[l++] = leidx;
                    continue block1;
                }
            }
            if (l == 0) {
                this.lockAssumptionFailed(ei, fi, ti);
                return empty;
            }
            if (l < newLset.length) {
                this.lset = new int[l];
                System.arraycopy(newLset, 0, this.lset, 0, l);
            }
        }
        return this;
    }

    @Override
    public boolean isProtected() {
        return this.checkLevel >= 5;
    }

    @Override
    public FieldLockInfo cleanUp() {
        DynamicArea area = DynamicArea.getHeap();
        int[] newSet = null;
        int l = 0;
        if (this.lset != null) {
            for (int i = 0; i < this.lset.length; ++i) {
                if (area.get(this.lset[i]) == null) {
                    if (newSet != null) continue;
                    newSet = new int[this.lset.length - 1];
                    if (i <= 0) continue;
                    System.arraycopy(this.lset, 0, newSet, 0, i);
                    l = i;
                    continue;
                }
                if (newSet == null) continue;
                newSet[l++] = this.lset[i];
            }
        }
        if (l == 1) {
            assert (newSet != null);
            return new SingleFieldLockInfo((int)newSet[0], this.checkLevel);
        }
        if (newSet != null) {
            if (l == newSet.length) {
                this.lset = newSet;
            } else {
                if (l == 0) {
                    return empty;
                }
                this.lset = new int[l];
                System.arraycopy(newSet, 0, this.lset, 0, l);
            }
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("StatisticFieldLockInfo [");
        sb.append("checkLevel=");
        sb.append(this.checkLevel);
        sb.append(",lset={");
        if (this.lset != null) {
            for (int i = 0; i < this.lset.length; ++i) {
                if (i > 0) {
                    sb.append(',');
                }
                sb.append(this.lset[i]);
            }
        }
        sb.append("}]");
        return sb.toString();
    }
}

