/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.jpf.jvm;

import gov.nasa.jpf.jvm.ClassInfo;
import gov.nasa.jpf.jvm.FieldInfo;
import gov.nasa.jpf.jvm.Fields;

public class StaticFields
extends Fields {
    public StaticFields(ClassInfo ci) {
        super(ci.getType(), ci, ci.getStaticDataSize());
    }

    @Override
    public String getLogChar() {
        return "@";
    }

    @Override
    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof StaticFields)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    public FieldInfo getFieldInfo(int index) {
        return this.ci.getStaticField(index);
    }

    @Override
    public int getNumberOfFields() {
        return this.ci.getNumberOfStaticFields();
    }

    @Override
    protected FieldInfo findFieldInfo(int storageOffset) {
        int length;
        for (int i = length = Math.min(storageOffset, this.ci.getNumberOfStaticFields() - 1); i >= 0; --i) {
            FieldInfo fi = this.ci.getStaticField(i);
            if (fi.getStorageOffset() != storageOffset) continue;
            return fi;
        }
        return null;
    }
}

