/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.jpf.jvm;

import gov.nasa.jpf.JPFException;
import gov.nasa.jpf.jvm.ClassInfo;
import gov.nasa.jpf.jvm.ClassRef;
import gov.nasa.jpf.jvm.DynamicArea;
import gov.nasa.jpf.jvm.ElementInfo;
import gov.nasa.jpf.jvm.FieldInfo;
import gov.nasa.jpf.jvm.Fields;
import gov.nasa.jpf.jvm.Monitor;
import gov.nasa.jpf.jvm.Ref;
import gov.nasa.jpf.jvm.StaticArea;
import gov.nasa.jpf.jvm.ThreadInfo;

public final class StaticElementInfo
extends ElementInfo {
    int classObjectRef = -1;
    int status = -1;

    public StaticElementInfo() {
    }

    public StaticElementInfo(Fields f, Monitor m, int classObjRef) {
        super(f, m);
        this.classObjectRef = classObjRef;
    }

    @Override
    public void setIntField(FieldInfo fi, int value) {
        ElementInfo ei = this.getElementInfo(fi.getClassInfo());
        if (fi.isReference()) {
            throw new JPFException("reference field: " + fi.getName());
        }
        ei.cloneFields().setIntValue(ei, fi.getStorageOffset(), value);
    }

    public int getStatus() {
        return this.status;
    }

    void setStatus(int newStatus) {
        if (this.status != newStatus) {
            this.status = newStatus;
            this.area.markChanged(this.index);
        }
    }

    public void restoreStatus(int s) {
        this.status = s;
    }

    void createStartupClassObject(ClassInfo ci, ThreadInfo ti) {
        this.classObjectRef = ci.createClassObject(ti, this.index);
    }

    @Override
    protected FieldInfo getDeclaredFieldInfo(String clsBase, String fname) {
        ClassInfo ci = ClassInfo.getClassInfo(clsBase);
        FieldInfo fi = ci.getDeclaredStaticField(fname);
        if (fi == null) {
            throw new JPFException("class " + ci.getName() + " has no static field " + fname);
        }
        return fi;
    }

    @Override
    public FieldInfo getFieldInfo(String fname) {
        ClassInfo ci = this.getClassInfo();
        return ci.getStaticField(fname);
    }

    protected void checkFieldInfo(FieldInfo fi) {
        if (this.getClassInfo() != fi.getClassInfo()) {
            throw new JPFException("wrong static FieldInfo : " + fi.getName() + " , no such field in class " + this.getClassInfo().getName());
        }
    }

    @Override
    public int getNumberOfFields() {
        return this.getClassInfo().getNumberOfStaticFields();
    }

    @Override
    public FieldInfo getFieldInfo(int fieldIndex) {
        return this.getClassInfo().getStaticField(fieldIndex);
    }

    @Override
    protected ElementInfo getElementInfo(ClassInfo ci) {
        if (ci == this.getClassInfo()) {
            return this;
        }
        return ((StaticArea)this.area).get(ci.getName());
    }

    void markStaticRoot() {
        DynamicArea heap = DynamicArea.getHeap();
        ClassInfo ci = this.getClassInfo();
        int n = ci.getNumberOfStaticFields();
        for (int i = 0; i < n; ++i) {
            FieldInfo fi = ci.getStaticField(i);
            if (!fi.isReference()) continue;
            heap.markStaticRoot(this.fields.getIntValue(fi.getStorageOffset()));
        }
        heap.markStaticRoot(this.classObjectRef);
    }

    @Override
    protected Ref getRef() {
        return new ClassRef(this.getIndex());
    }

    public int getClassObjectRef() {
        return this.classObjectRef;
    }

    public void restoreClassObjectRef(int r) {
        this.classObjectRef = r;
    }

    @Override
    public String toString() {
        return this.getClassInfo().getName();
    }
}

