/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.jpf.jvm;

import gov.nasa.jpf.JPF;
import gov.nasa.jpf.jvm.DynamicArea;
import gov.nasa.jpf.jvm.ElementInfo;
import gov.nasa.jpf.jvm.FieldInfo;
import gov.nasa.jpf.jvm.FieldLockInfo;
import gov.nasa.jpf.jvm.StatisticFieldLockInfo;
import gov.nasa.jpf.jvm.ThreadInfo;
import java.util.LinkedList;
import java.util.logging.Logger;

public class SingleFieldLockInfo
extends FieldLockInfo {
    static Logger log = JPF.getLogger("gov.nasa.jpf.jvm.FieldLockInfo");
    int lock;
    int checkLevel;

    SingleFieldLockInfo(int lockRef, int nChecks) {
        this.lock = lockRef;
        this.checkLevel = nChecks;
    }

    void lockAssumptionFailed(ElementInfo ei, FieldInfo fi, ThreadInfo ti) {
        String src = ti.getMethod().getClassInfo().getSourceFileName();
        int line = ti.getLine();
        StringBuilder sb = new StringBuilder();
        sb.append("unprotected field access of: ");
        sb.append(ei);
        sb.append('.');
        sb.append(fi.getName());
        sb.append(" in thread: ");
        sb.append(ti.getName());
        sb.append(" (");
        sb.append(src);
        sb.append(':');
        sb.append(line);
        sb.append(")\nassumed lock: ");
        sb.append(DynamicArea.getHeap().get(this.lock));
        sb.append(", current locks: ");
        StatisticFieldLockInfo.appendLockSet(sb, ti.getLockedObjectReferences());
        sb.append("\n >>> re-run with 'vm.por.sync_detection=false' or exclude field from checks <<<");
        log.severe(sb.toString());
    }

    @Override
    public FieldLockInfo checkProtection(ElementInfo ei, FieldInfo fi, ThreadInfo ti) {
        LinkedList<ElementInfo> currentLocks = ti.getLockedObjects();
        int n = currentLocks.size();
        boolean active = false;
        ++this.checkLevel;
        for (int i = 0; i < n; ++i) {
            ElementInfo lei = (ElementInfo)currentLocks.get(i);
            if (lei.getIndex() != this.lock) continue;
            active = true;
            break;
        }
        if (!active) {
            if (this.checkLevel > 5) {
                this.lockAssumptionFailed(ei, fi, ti);
            }
            return empty;
        }
        return this;
    }

    @Override
    public boolean isProtected() {
        return this.checkLevel >= 5;
    }

    @Override
    public FieldLockInfo cleanUp() {
        DynamicArea area = DynamicArea.getHeap();
        if (area.get(this.lock) == null) {
            return FieldLockInfo.empty;
        }
        return this;
    }

    public String toString() {
        return "SingleFieldLockInfo [checkLevel=" + this.checkLevel + ",lock=" + this.lock + ']';
    }
}

