/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.jpf.jvm;

import gov.nasa.jpf.JPFException;
import gov.nasa.jpf.jvm.ClassInfo;
import gov.nasa.jpf.jvm.DynamicArea;
import gov.nasa.jpf.jvm.DynamicElementInfo;
import gov.nasa.jpf.jvm.ElementInfo;
import gov.nasa.jpf.jvm.FieldInfo;
import gov.nasa.jpf.jvm.Fields;
import org.apache.bcel.classfile.ConstantValue;

public class ReferenceFieldInfo
extends FieldInfo {
    int init = -1;
    String sInit;

    public ReferenceFieldInfo(String name, String type, int modifiers, ConstantValue cv, ClassInfo ci, int idx, int off) {
        super(name, type, modifiers, cv, ci, idx, off);
        this.init = this.computeInitValue(cv);
    }

    @Override
    public String valueToString(Fields f) {
        int i = f.getIntValue(this.storageOffset);
        if (i == -1) {
            return "null";
        }
        return ((DynamicElementInfo)DynamicArea.getHeap().get(i)).toString();
    }

    @Override
    public boolean isReference() {
        return true;
    }

    @Override
    public boolean isArrayField() {
        return this.ci.isArray;
    }

    int computeInitValue(ConstantValue cv) {
        if (cv == null) {
            return -1;
        }
        String s = cv.toString();
        if (s.charAt(0) != '\"') {
            throw new JPFException("unsupported reference initialization: " + s);
        }
        this.sInit = s = s.substring(1, s.length() - 1);
        return -1;
    }

    @Override
    public void initialize(ElementInfo ei) {
        int ref = this.init;
        if (this.sInit != null) {
            ref = DynamicArea.getHeap().newString(this.sInit, null);
        }
        ei.getFields().setReferenceValue(ei, this.storageOffset, ref);
    }

    @Override
    public Object getValueObject(Fields f) {
        int i = f.getIntValue(this.storageOffset);
        if (i == -1) {
            return null;
        }
        return DynamicArea.getHeap().get(i);
    }
}

