/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.jpf.jvm;

import gov.nasa.jpf.Config;
import gov.nasa.jpf.jvm.ChoiceGenerator;
import gov.nasa.jpf.jvm.DefaultSchedulerFactory;
import gov.nasa.jpf.jvm.ElementInfo;
import gov.nasa.jpf.jvm.JVM;
import gov.nasa.jpf.jvm.SystemState;
import gov.nasa.jpf.jvm.ThreadInfo;
import gov.nasa.jpf.jvm.choice.ThreadChoiceFromSet;

public class PrioritySchedulerFactory
extends DefaultSchedulerFactory {
    public PrioritySchedulerFactory(Config config, JVM vm, SystemState ss) {
        super(config, vm, ss);
    }

    @Override
    protected ThreadInfo[] filter(ThreadInfo[] list) {
        int i;
        int top = 1;
        int nTop = 0;
        if (list == null || list.length <= 1) {
            return list;
        }
        for (i = 0; i < list.length; ++i) {
            int prio = list[i].getPriority();
            if (prio > top) {
                top = prio;
                nTop = 1;
                continue;
            }
            if (prio != top) continue;
            ++nTop;
        }
        if (nTop == list.length) {
            return list;
        }
        ThreadInfo[] topList = new ThreadInfo[nTop];
        int j = 0;
        for (i = 0; i < list.length && j < nTop; ++i) {
            if (list[i].getPriority() != top) continue;
            topList[j++] = list[i];
        }
        return topList;
    }

    @Override
    public ChoiceGenerator<ThreadInfo> createThreadStartCG(ThreadInfo newThread) {
        if (this.ss.isAtomic()) {
            return null;
        }
        return new ThreadChoiceFromSet(this.getRunnables(), true);
    }

    @Override
    public ChoiceGenerator<ThreadInfo> createMonitorExitCG(ElementInfo ei, ThreadInfo ti) {
        if (this.ss.isAtomic()) {
            return null;
        }
        return new ThreadChoiceFromSet(this.getRunnables(), true);
    }
}

