/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.jpf.jvm;

import gov.nasa.jpf.jvm.Transition;
import gov.nasa.jpf.util.Printable;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.LinkedList;

public class Path
implements Printable,
Iterable<Transition>,
Cloneable {
    String application;
    private LinkedList<Transition> stack;

    private Path() {
    }

    public Path(String app) {
        this.application = app;
        this.stack = new LinkedList();
    }

    public Path clone() {
        Path clone = new Path();
        clone.application = this.application;
        clone.stack = (LinkedList)this.stack.clone();
        return clone;
    }

    public String getApplication() {
        return this.application;
    }

    public Transition getLast() {
        if (this.stack.isEmpty()) {
            return null;
        }
        return this.stack.getLast();
    }

    public void add(Transition t) {
        this.stack.add(t);
    }

    public Transition get(int pos) {
        return this.stack.get(pos);
    }

    public boolean isEmpty() {
        return this.stack.size() == 0;
    }

    public int size() {
        return this.stack.size();
    }

    public boolean hasOutput() {
        for (Transition t : this.stack) {
            if (t.getOutput() == null) continue;
            return true;
        }
        return false;
    }

    public void printOutputOn(PrintWriter pw) {
        for (Transition t : this.stack) {
            String output = t.getOutput();
            if (t == null) continue;
            pw.print(output);
        }
    }

    @Override
    public void printOn(PrintWriter pw) {
    }

    public void removeLast() {
        this.stack.removeLast();
    }

    @Override
    public Iterator<Transition> iterator() {
        return this.stack.iterator();
    }
}

