/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.jpf.jvm;

import gov.nasa.jpf.Config;
import gov.nasa.jpf.GenericProperty;
import gov.nasa.jpf.jvm.JVM;
import gov.nasa.jpf.jvm.ThreadInfo;
import gov.nasa.jpf.search.Search;
import java.io.PrintWriter;
import java.io.StringWriter;

public class NotDeadlockedProperty
extends GenericProperty {
    Search search;

    public NotDeadlockedProperty(Config conf, Search search) {
        this.search = search;
    }

    @Override
    public String getErrorMessage() {
        ThreadInfo[] liveThreads;
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        pw.print("deadlock encountered:\n");
        for (ThreadInfo ti : liveThreads = this.search.getVM().getLiveThreads()) {
            pw.print("  ");
            pw.println(ti.getStateDescription());
        }
        return sw.toString();
    }

    @Override
    public boolean check(Search search, JVM vm) {
        return !vm.isDeadlocked();
    }
}

