/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.jpf.jvm;

import gov.nasa.jpf.Config;
import gov.nasa.jpf.JPF;
import gov.nasa.jpf.JPFException;
import gov.nasa.jpf.jvm.BooleanChoiceGenerator;
import gov.nasa.jpf.jvm.ChoiceGenerator;
import gov.nasa.jpf.jvm.ClassInfo;
import gov.nasa.jpf.jvm.DoubleChoiceGenerator;
import gov.nasa.jpf.jvm.DynamicArea;
import gov.nasa.jpf.jvm.DynamicElementInfo;
import gov.nasa.jpf.jvm.ElementInfo;
import gov.nasa.jpf.jvm.FieldInfo;
import gov.nasa.jpf.jvm.IntChoiceGenerator;
import gov.nasa.jpf.jvm.MJIEnv;
import gov.nasa.jpf.jvm.ReferenceChoiceGenerator;
import gov.nasa.jpf.jvm.StackFrame;
import gov.nasa.jpf.jvm.SystemState;
import gov.nasa.jpf.jvm.ThreadInfo;
import gov.nasa.jpf.jvm.Types;
import gov.nasa.jpf.jvm.Verify;
import gov.nasa.jpf.jvm.choice.CustomBooleanChoiceGenerator;
import gov.nasa.jpf.jvm.choice.IntIntervalGenerator;
import gov.nasa.jpf.util.RunListener;
import gov.nasa.jpf.util.RunRegistry;

public class JPF_gov_nasa_jpf_jvm_Verify {
    static final int MAX_COUNTERS = 10;
    static boolean isInitialized;
    static int[] counter;
    static boolean supportIgnorePath;
    static Config config;
    static Class[] cgArgTypes;
    static Object[] cgArgs;

    public static void init(Config conf) {
        if (!isInitialized) {
            supportIgnorePath = conf.getBoolean("vm.verify.ignore_path");
            counter = null;
            config = conf;
            Verify.setPeerClass(JPF_gov_nasa_jpf_jvm_Verify.class);
            RunRegistry.getDefaultRegistry().addListener(new RunListener(){

                @Override
                public void reset(RunRegistry reg) {
                    isInitialized = false;
                }
            });
        }
    }

    public static final int getCounter__I__I(MJIEnv env, int clsObjRef, int counterId) {
        if (counter == null || counterId < 0 || counterId >= counter.length) {
            return 0;
        }
        return counter[counterId];
    }

    public static final void resetCounter__I__V(MJIEnv env, int clsObjRef, int counterId) {
        if (counter == null || counterId < 0 || counterId >= counter.length) {
            return;
        }
        JPF_gov_nasa_jpf_jvm_Verify.counter[counterId] = 0;
    }

    public static final int incrementCounter__I__I(MJIEnv env, int clsObjRef, int counterId) {
        if (counterId < 0) {
            return 0;
        }
        if (counter == null) {
            counter = new int[counterId >= 10 ? counterId + 1 : 10];
        } else if (counterId >= counter.length) {
            int[] newCounter = new int[counterId + 1];
            System.arraycopy(counter, 0, newCounter, 0, counter.length);
            counter = newCounter;
        }
        int n = counterId;
        int n2 = counter[n] + 1;
        counter[n] = n2;
        return n2;
    }

    public static final long currentTimeMillis____J(MJIEnv env, int clsObjRef) {
        return System.currentTimeMillis();
    }

    public static String getType(int objRef, MJIEnv env) {
        DynamicArea da = env.getDynamicArea();
        return Types.getTypeName(((DynamicElementInfo)da.get(objRef)).getType());
    }

    public static void addComment__Ljava_lang_String_2__V(MJIEnv env, int clsObjRef, int stringRef) {
        SystemState ss = env.getSystemState();
        String cmt = env.getStringObject(stringRef);
        ss.getTrail().setAnnotation(cmt);
    }

    public static void assertTrue__Z__V(MJIEnv env, int clsObjRef, boolean b) {
        if (!b) {
            env.throwException("java.lang.AssertionError", "assertTrue failed");
        }
    }

    public static void beginAtomic____V(MJIEnv env, int clsObjRef) {
        env.getSystemState().incAtomic();
    }

    public static void endAtomic____V(MJIEnv env, int clsObjRef) {
        env.getSystemState().decAtomic();
    }

    public static void busyWait__J__V(MJIEnv env, int clsObjRef, long duration) {
    }

    public static void ignoreIf__Z__V(MJIEnv env, int clsObjRef, boolean cond) {
        if (supportIgnorePath) {
            env.getSystemState().setIgnored(cond);
        }
    }

    public static void interesting__Z__V(MJIEnv env, int clsObjRef, boolean cond) {
        env.getSystemState().setInteresting(cond);
    }

    public static boolean isCalledFromClass__Ljava_lang_String_2__Z(MJIEnv env, int clsObjRef, int clsNameRef) {
        String refClassName = env.getStringObject(clsNameRef);
        ThreadInfo ti = env.getThreadInfo();
        int stackDepth = ti.countStackFrames();
        if (stackDepth < 2) {
            return false;
        }
        String mthClassName = ti.getCallStackClass(1);
        ClassInfo ci = ClassInfo.getClassInfo(mthClassName);
        return ci.isInstanceOf(refClassName);
    }

    public static final boolean getBoolean____Z(MJIEnv env, int clsObjRef) {
        ThreadInfo ti = env.getThreadInfo();
        SystemState ss = env.getSystemState();
        if (!ti.isFirstStepInsn()) {
            BooleanChoiceGenerator cg = new BooleanChoiceGenerator(config, "boolean");
            ss.setNextChoiceGenerator(cg);
            env.repeatInvocation();
            return true;
        }
        ChoiceGenerator<?> cg = ss.getChoiceGenerator();
        assert (cg != null && cg instanceof BooleanChoiceGenerator) : "expected BooleanChoiceGenerator, got: " + cg;
        return ((BooleanChoiceGenerator)cg).getNextChoice();
    }

    public static final boolean getBoolean__Z__Z(MJIEnv env, int clsObjRef, boolean falseFirst) {
        ThreadInfo ti = env.getThreadInfo();
        SystemState ss = env.getSystemState();
        if (!ti.isFirstStepInsn()) {
            CustomBooleanChoiceGenerator cg = new CustomBooleanChoiceGenerator(falseFirst, "boolean");
            ss.setNextChoiceGenerator(cg);
            env.repeatInvocation();
            return true;
        }
        ChoiceGenerator<?> cg = ss.getChoiceGenerator();
        assert (cg != null && cg instanceof CustomBooleanChoiceGenerator) : "expected CustomBooleanChoiceGenerator, got: " + cg;
        return ((CustomBooleanChoiceGenerator)cg).getNextChoice();
    }

    public static int getInt__II__I(MJIEnv env, int clsObjRef, int min, int max) {
        ThreadInfo ti = env.getThreadInfo();
        SystemState ss = env.getSystemState();
        if (!ti.isFirstStepInsn()) {
            if (min == max) {
                return min;
            }
            IntIntervalGenerator cg = new IntIntervalGenerator(min, max);
            ss.setNextChoiceGenerator(cg);
            env.repeatInvocation();
            return 0;
        }
        ChoiceGenerator<?> cg = ss.getChoiceGenerator();
        assert (cg != null && cg instanceof IntChoiceGenerator) : "expected IntChoiceGenerator, got: " + cg;
        return ((IntChoiceGenerator)cg).getNextChoice();
    }

    public static void print__Ljava_lang_String_2I__V(MJIEnv env, int clsRef, int sRef, int val) {
        String s = env.getStringObject(sRef);
        System.out.println(s + " : " + val);
    }

    public static void print__Ljava_lang_String_2Z__V(MJIEnv env, int clsRef, int sRef, boolean val) {
        String s = env.getStringObject(sRef);
        System.out.println(s + " : " + val);
    }

    public static void print___3Ljava_lang_String_2__V(MJIEnv env, int clsRef, int argsRef) {
        int n = env.getArrayLength(argsRef);
        for (int i = 0; i < n; ++i) {
            int aref = env.getReferenceArrayElement(argsRef, i);
            String s = env.getStringObject(aref);
            System.out.print(s);
        }
    }

    public static void println____V(MJIEnv env, int clsRef) {
        System.out.println();
    }

    public static void setFieldAttribute__Ljava_lang_Object_2Ljava_lang_String_2I__V(MJIEnv env, int clsRef, int oRef, int fnRef, int attr) {
        if (oRef != -1) {
            String fname;
            ElementInfo ei = env.getElementInfo(oRef);
            FieldInfo fi = ei.getFieldInfo(fname = env.getStringObject(fnRef));
            if (fi != null) {
                ei.setFieldAttr(fi, new Integer(attr));
            } else {
                env.throwException("java.lang.NoSuchFieldException", ei.getClassInfo().getName() + '.' + fname);
            }
        }
    }

    public static int getFieldAttribute__Ljava_lang_Object_2Ljava_lang_String_2__I(MJIEnv env, int clsRef, int oRef, int fnRef) {
        if (oRef != -1) {
            String fname;
            ElementInfo ei = env.getElementInfo(oRef);
            FieldInfo fi = ei.getFieldInfo(fname = env.getStringObject(fnRef));
            if (fi != null) {
                Object val = ei.getFieldAttr(fi);
                if (val != null) {
                    if (val instanceof Integer) {
                        int ret = (Integer)val;
                        return ret;
                    }
                    env.throwException("java.lang.RuntimeException", ei.toString() + '.' + fname + " attribute not and int: " + val);
                }
            } else {
                env.throwException("java.lang.NoSuchFieldException", ei.toString() + '.' + fname);
            }
        }
        return 0;
    }

    public static void setLocalAttribute__Ljava_lang_String_2I__V(MJIEnv env, int clsRef, int snRef, int attr) {
        String slotName = env.getStringObject(snRef);
        ThreadInfo ti = env.getThreadInfo();
        StackFrame frame = ti.getTopFrame();
        if (!frame.getMethodInfo().isStatic() && slotName.equals("this")) {
            frame.setLocalAttr(0, new Integer(attr));
        } else {
            int slotIdx = frame.getLocalVariableOffset(slotName);
            if (slotIdx >= 0) {
                frame.setLocalAttr(slotIdx, new Integer(attr));
            } else {
                env.throwException("java.lang.RuntimeException", "local variable not found: " + slotName);
            }
        }
    }

    public static int getLocalAttribute__Ljava_lang_String_2__I(MJIEnv env, int clsRef, int snRef) {
        String slotName = env.getStringObject(snRef);
        ThreadInfo ti = env.getThreadInfo();
        StackFrame frame = ti.getTopFrame();
        int slotIdx = frame.getLocalVariableOffset(slotName);
        if (slotIdx >= 0) {
            Object val = frame.getLocalAttr(slotIdx);
            if (val instanceof Integer) {
                return (Integer)val;
            }
            env.throwException("java.lang.RuntimeException", "attribute for local var: " + slotName + " not an int: " + val);
            return 0;
        }
        env.throwException("java.lang.RuntimeException", "local variable not found: " + slotName);
        return 0;
    }

    public static void setElementAttribute__Ljava_lang_Object_2II__V(MJIEnv env, int clsRef, int oRef, int idx, int attr) {
        if (oRef != -1) {
            ElementInfo ei = env.getElementInfo(oRef);
            if (ei.isArray()) {
                if (idx < ei.arrayLength()) {
                    ei.setElementAttr(idx, new Integer(attr));
                } else {
                    env.throwException("java.lang.ArrayIndexOutOfBoundsException", Integer.toString(idx));
                }
            } else {
                env.throwException("java.lang.RuntimeException", "not an array: " + ei);
            }
        }
    }

    public static int getElementAttribute__Ljava_lang_Object_2I__I(MJIEnv env, int clsRef, int oRef, int idx) {
        if (oRef != -1) {
            ElementInfo ei = env.getElementInfo(oRef);
            if (ei.isArray()) {
                if (idx < ei.arrayLength()) {
                    Object val = ei.getElementAttr(idx);
                    if (val != null) {
                        if (val instanceof Integer) {
                            int ret = (Integer)val;
                            return ret;
                        }
                        env.throwException("java.lang.RuntimeException", ei.toString() + '[' + idx + "] attribute not and int: " + val);
                    }
                } else {
                    env.throwException("java.lang.ArrayIndexOutOfBoundsException", Integer.toString(idx));
                }
            } else {
                env.throwException("java.lang.RuntimeException", "not an array: " + ei);
            }
        }
        return 0;
    }

    static ChoiceGenerator createChoiceGenerator(SystemState ss, String id) {
        ChoiceGenerator gen = null;
        JPF_gov_nasa_jpf_jvm_Verify.cgArgs[0] = config;
        JPF_gov_nasa_jpf_jvm_Verify.cgArgs[1] = id;
        try {
            String key = id + ".class";
            gen = config.getEssentialInstance(key, ChoiceGenerator.class, cgArgTypes, cgArgs);
            ss.setNextChoiceGenerator(gen);
        }
        catch (Config.Exception cex) {
            throw new JPFException(cex);
        }
        return gen;
    }

    public static final int getInt__Ljava_lang_String_2__I(MJIEnv env, int clsObjRef, int idRef) {
        ThreadInfo ti = env.getThreadInfo();
        SystemState ss = env.getSystemState();
        if (!ti.isFirstStepInsn()) {
            String id = env.getStringObject(idRef);
            ChoiceGenerator cg = JPF_gov_nasa_jpf_jvm_Verify.createChoiceGenerator(ss, id);
            ss.setNextChoiceGenerator(cg);
            env.repeatInvocation();
            return 0;
        }
        ChoiceGenerator<?> cg = ss.getChoiceGenerator();
        assert (cg != null && cg instanceof IntChoiceGenerator) : "expected IntChoiceGenerator, got: " + cg;
        return ((IntChoiceGenerator)cg).getNextChoice();
    }

    public static int getObject__Ljava_lang_String_2__Ljava_lang_Object_2(MJIEnv env, int clsObjRef, int idRef) {
        ThreadInfo ti = env.getThreadInfo();
        SystemState ss = env.getSystemState();
        if (!ti.isFirstStepInsn()) {
            String id = env.getStringObject(idRef);
            ChoiceGenerator cg = JPF_gov_nasa_jpf_jvm_Verify.createChoiceGenerator(ss, id);
            ss.setNextChoiceGenerator(cg);
            env.repeatInvocation();
            return 0;
        }
        ChoiceGenerator<?> cg = ss.getChoiceGenerator();
        assert (cg != null && cg instanceof ReferenceChoiceGenerator) : "expected ReferenceChoiceGenerator, got: " + cg;
        return ((ReferenceChoiceGenerator)cg).getNextChoice();
    }

    public static final double getDouble__Ljava_lang_String_2__D(MJIEnv env, int clsObjRef, int idRef) {
        ThreadInfo ti = env.getThreadInfo();
        SystemState ss = env.getSystemState();
        if (!ti.isFirstStepInsn()) {
            String id = env.getStringObject(idRef);
            ChoiceGenerator cg = JPF_gov_nasa_jpf_jvm_Verify.createChoiceGenerator(ss, id);
            ss.setNextChoiceGenerator(cg);
            env.repeatInvocation();
            return 0.0;
        }
        ChoiceGenerator<?> cg = ss.getChoiceGenerator();
        assert (cg != null && cg instanceof DoubleChoiceGenerator) : "expected DoubleChoiceGenerator, got: " + cg;
        return ((DoubleChoiceGenerator)cg).getNextChoice();
    }

    public static final boolean randomBool(MJIEnv env, int clsObjRef) {
        return JPF_gov_nasa_jpf_jvm_Verify.getBoolean____Z(env, clsObjRef);
    }

    public static final int random__I__I(MJIEnv env, int clsObjRef, int x) {
        return JPF_gov_nasa_jpf_jvm_Verify.getInt__II__I(env, clsObjRef, 0, x);
    }

    static void boring__Z__V(MJIEnv env, int clsObjRef, boolean b) {
        env.getSystemState().setBoring(b);
    }

    protected static int[] arrayOfObjectsOfType(DynamicArea da, String type) {
        int[] map = new int[]{};
        int map_size = 0;
        for (int i = 0; i < da.getLength(); ++i) {
            if (da.get(i) == null || !Types.getTypeName(((DynamicElementInfo)da.get(i)).getType()).equals(type)) continue;
            if (map_size >= map.length) {
                int[] n = new int[map_size + 1];
                System.arraycopy(map, 0, n, 0, map.length);
                map = n;
            }
            map[map_size] = i;
            ++map_size;
        }
        return map;
    }

    public static boolean vmIsMatchingStates____Z(MJIEnv env, int clsObjRef) {
        return env.getVM().getStateSet() != null;
    }

    public static void storeTrace__Ljava_lang_String_2Ljava_lang_String_2__V(MJIEnv env, int clsObjRef, int filenameRef, int commentRef) {
        String fileName = env.getStringObject(filenameRef);
        String comment = env.getStringObject(commentRef);
        env.getVM().storeTrace(fileName, comment);
    }

    public static void terminateSearch____V(MJIEnv env, int clsObjRef) {
        JPF jpf = env.getVM().getJPF();
        jpf.getSearch().terminate();
    }

    public static boolean isTraceReplay____Z(MJIEnv env, int clsObjRef) {
        return env.getVM().isTraceReplay();
    }

    public static void setProperties___3Ljava_lang_String_2__V(MJIEnv env, int clsObjRef, int argRef) {
        if (argRef != -1) {
            Config conf = env.getConfig();
            int n = env.getArrayLength(argRef);
            for (int i = 0; i < n; ++i) {
                int pRef = env.getReferenceArrayElement(argRef, i);
                if (pRef == -1) continue;
                String p = env.getStringObject(pRef);
                config.parse(p);
            }
        }
    }

    static {
        cgArgTypes = new Class[]{Config.class, String.class};
        cgArgs = new Object[]{null, null};
    }
}

