/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.jpf.jvm;

import gov.nasa.jpf.jvm.ClassInfo;
import gov.nasa.jpf.jvm.ElementInfo;
import gov.nasa.jpf.jvm.FieldInfo;
import gov.nasa.jpf.jvm.Fields;
import org.apache.bcel.classfile.ConstantValue;

public class IntegerFieldInfo
extends FieldInfo {
    int init;

    public IntegerFieldInfo(String name, String type, int modifiers, ConstantValue cv, ClassInfo ci, int idx, int off) {
        super(name, type, modifiers, cv, ci, idx, off);
        this.init = cv != null ? Integer.parseInt(cv.toString()) : 0;
    }

    @Override
    public void initialize(ElementInfo ei) {
        ei.getFields().setIntValue(ei, this.storageOffset, this.init);
    }

    @Override
    public String valueToString(Fields f) {
        int i = f.getIntValue(this.storageOffset);
        return Integer.toString(i);
    }

    @Override
    public Object getValueObject(Fields f) {
        int i = f.getIntValue(this.storageOffset);
        if (this.type.equals("int")) {
            return new Integer(i);
        }
        if (this.type.equals("boolean")) {
            return new Boolean(i != 0);
        }
        if (this.type.equals("byte")) {
            return new Byte((byte)i);
        }
        if (this.type.equals("char")) {
            return new Character((char)i);
        }
        if (this.type.equals("short")) {
            return new Short((short)i);
        }
        throw new UnsupportedOperationException("unknown field type: " + this.type);
    }
}

