/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.jpf.jvm;

import gov.nasa.jpf.JPFException;
import gov.nasa.jpf.jvm.ClassInfo;
import gov.nasa.jpf.jvm.ElementInfo;
import gov.nasa.jpf.jvm.FieldInfo;
import gov.nasa.jpf.jvm.Types;
import gov.nasa.jpf.util.HashData;
import gov.nasa.jpf.util.IntVector;

public abstract class Fields
implements Cloneable {
    static int FATTR_MASK = 65535;
    protected final String type;
    protected final ClassInfo ci;
    protected int[] values;
    private int untracked;
    protected Object[] attrs;

    protected Fields(String type, ClassInfo ci, int dataSize) {
        this.type = type;
        this.ci = ci;
        this.values = new int[dataSize];
    }

    public boolean hasAttrs() {
        return this.attrs != null;
    }

    public void setAttr(int fieldOrElementIndex, Object attr) {
        if (this.attrs == null) {
            if (attr == null) {
                return;
            }
            this.attrs = new Object[this.getNumberOfFieldsOrElements()];
        }
        this.attrs[fieldOrElementIndex] = attr;
    }

    public Object getAttr(int fieldOrElementIndex) {
        if (this.attrs != null) {
            return this.attrs[fieldOrElementIndex];
        }
        return null;
    }

    int getNumberOfFieldsOrElements() {
        return this.getNumberOfFields();
    }

    public int getHeapSize() {
        return this.values.length * 4;
    }

    public boolean hasRefField(int objRef) {
        return this.ci.hasRefField(objRef, this);
    }

    public boolean isArray() {
        return Types.getBaseType(this.type) == 13;
    }

    public boolean isReferenceArray() {
        return false;
    }

    public ClassInfo getClassInfo() {
        return this.ci;
    }

    public abstract int getNumberOfFields();

    public abstract FieldInfo getFieldInfo(int var1);

    public int getIntValue(int index) {
        return this.values[index];
    }

    public boolean isEqual(Fields other, int off, int len, int otherOff) {
        int iEnd = off + len;
        int jEnd = otherOff + len;
        int[] v = other.values;
        if (iEnd > this.values.length || jEnd > v.length) {
            return false;
        }
        int i = off;
        int j = otherOff;
        while (i < iEnd) {
            if (this.values[i] != v[j]) {
                return false;
            }
            ++i;
            ++j;
        }
        return true;
    }

    public int getReferenceValue(int index) {
        return this.values[index];
    }

    public long getLongValue(int index) {
        return Types.intsToLong(this.values[index + 1], this.values[index]);
    }

    public boolean getBooleanValue(int index) {
        return Types.intToBoolean(this.values[index]);
    }

    public byte getByteValue(int index) {
        return (byte)this.values[index];
    }

    public char getCharValue(int index) {
        return (char)this.values[index];
    }

    public short getShortValue(int index) {
        return (short)this.values[index];
    }

    protected int[] getValues() {
        return this.values;
    }

    public void setReferenceValue(ElementInfo ei, int index, int newValue) {
        this.values[index] = newValue;
    }

    public void setBooleanValue(ElementInfo ei, int index, boolean newValue) {
        this.values[index] = newValue ? 1 : 0;
    }

    public void setByteValue(ElementInfo ei, int index, byte newValue) {
        this.values[index] = newValue;
    }

    public void setCharValue(ElementInfo ei, int index, char newValue) {
        this.values[index] = newValue;
    }

    public void setShortValue(ElementInfo ei, int index, short newValue) {
        this.values[index] = newValue;
    }

    public void setFloatValue(ElementInfo ei, int index, float newValue) {
        this.values[index] = Types.floatToInt(newValue);
    }

    public void setIntValue(ElementInfo ei, int index, int newValue) {
        this.values[index] = newValue;
    }

    public void setLongValue(ElementInfo ei, int index, long newValue) {
        this.values[index++] = Types.hiLong(newValue);
        this.values[index] = Types.loLong(newValue);
    }

    public void setDoubleValue(ElementInfo ei, int index, double newValue) {
        this.values[index++] = Types.hiDouble(newValue);
        this.values[index] = Types.loDouble(newValue);
    }

    public float getFloatValue(int index) {
        return Types.intToFloat(this.values[index]);
    }

    public double getDoubleValue(int index) {
        return Types.intsToDouble(this.values[index + 1], this.values[index]);
    }

    public String getType() {
        return this.type;
    }

    public Fields clone() {
        Fields f;
        try {
            f = (Fields)super.clone();
            f.values = (int[])this.values.clone();
            if (this.attrs != null) {
                f.attrs = (Object[])this.attrs.clone();
            }
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError(e.getMessage());
        }
        return f;
    }

    public boolean equals(Object o) {
        Object[] a1;
        if (o == null || !(o instanceof Fields)) {
            return false;
        }
        Fields f = (Fields)o;
        if (!this.type.equals(f.type) || this.ci != f.ci) {
            return false;
        }
        int[] v1 = this.values;
        int l = v1.length;
        int[] v2 = f.values;
        if (l != v2.length) {
            return false;
        }
        for (int i = 0; i < l; ++i) {
            if (v1[i] == v2[i]) continue;
            return false;
        }
        Object[] a = this.attrs;
        if (a == null != ((a1 = f.attrs) == null)) {
            return false;
        }
        if (a != null) {
            l = a.length;
            if (l != a1.length) {
                return false;
            }
            for (int i = 0; i < l; ++i) {
                if (a[i] == null) {
                    if (a1[i] == null) continue;
                    return false;
                }
                if (a1[i] == null) {
                    return false;
                }
                if (a[i].equals(a1[i])) continue;
                return false;
            }
        }
        return true;
    }

    public void copyTo(IntVector v) {
        v.append(this.values);
    }

    public void hash(HashData hd) {
        int[] v = this.values;
        int l = v.length;
        for (int i = 0; i < l; ++i) {
            hd.add(v[i]);
        }
        Object[] a = this.attrs;
        if (a != null) {
            int l2 = a.length;
            for (int i = 0; i < l2; ++i) {
                hd.add(a[i]);
            }
        }
    }

    public int arrayLength() {
        throw new JPFException("attempt to get length of non-array: " + this.ci.getName());
    }

    public boolean[] asBooleanArray() {
        throw new JPFException("not an array object: " + this.ci.getName());
    }

    public byte[] asByteArray() {
        throw new JPFException("not an array object: " + this.ci.getName());
    }

    public char[] asCharArray() {
        throw new JPFException("not an array object: " + this.ci.getName());
    }

    public short[] asShortArray() {
        throw new JPFException("not an array object: " + this.ci.getName());
    }

    public int[] asIntArray() {
        throw new JPFException("not an array object: " + this.ci.getName());
    }

    public long[] asLongArray() {
        throw new JPFException("not an array object: " + this.ci.getName());
    }

    public float[] asFloatArray() {
        throw new JPFException("not an array object: " + this.ci.getName());
    }

    public double[] asDoubleArray() {
        throw new JPFException("not an array object: " + this.ci.getName());
    }

    public int hashCode() {
        HashData hd = new HashData();
        this.hash(hd);
        return hd.getValue();
    }

    public int size() {
        return this.values.length;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Fields(type=");
        sb.append(this.type);
        sb.append(',');
        sb.append("ci=");
        sb.append(this.ci.getName());
        sb.append(',');
        sb.append("values=");
        sb.append('[');
        for (int i = 0; i < this.values.length; ++i) {
            if (i != 0) {
                sb.append(',');
            }
            sb.append(this.values[i]);
        }
        sb.append(']');
        sb.append(',');
        sb.append(')');
        return sb.toString();
    }

    protected abstract String getLogChar();

    public int[] dumpRawValues() {
        return this.values;
    }

    public void copyFrom(Fields other) {
        assert (other.ci == this.ci);
        System.arraycopy(other.values, 0, this.values, 0, this.values.length);
        if (other.attrs != null) {
            if (this.attrs == null) {
                this.attrs = (Object[])other.attrs.clone();
            } else {
                System.arraycopy(other.attrs, 0, this.attrs, 0, this.attrs.length);
            }
        }
    }

    public void setUntracked(int untracked) {
        this.untracked = untracked;
    }

    public int getUntracked() {
        return this.untracked;
    }

    public boolean isUntracked() {
        return this.untracked > 0;
    }

    public void incUntracked() {
        ++this.untracked;
    }

    public void decUntracked() {
        --this.untracked;
    }

    private boolean isFieldUntracked(int storageOffset) {
        FieldInfo fi = this.findFieldInfo(storageOffset);
        return fi != null ? fi.isUntracked() : false;
    }

    protected FieldInfo findFieldInfo(int storageOffset) {
        return null;
    }
}

