/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.jpf.jvm;

import gov.nasa.jpf.jvm.ClassInfo;
import gov.nasa.jpf.jvm.DoubleFieldInfo;
import gov.nasa.jpf.jvm.ElementInfo;
import gov.nasa.jpf.jvm.Fields;
import gov.nasa.jpf.jvm.FloatFieldInfo;
import gov.nasa.jpf.jvm.InfoObject;
import gov.nasa.jpf.jvm.IntegerFieldInfo;
import gov.nasa.jpf.jvm.LongFieldInfo;
import gov.nasa.jpf.jvm.ReferenceFieldInfo;
import gov.nasa.jpf.jvm.Types;
import org.apache.bcel.classfile.ConstantValue;
import org.apache.bcel.classfile.Field;

public abstract class FieldInfo
extends InfoObject {
    protected final String name;
    protected final String type;
    protected int storageSize;
    protected final ClassInfo ci;
    protected final ConstantValue cv;
    final int fieldIndex;
    final int storageOffset;
    protected int modifiers;
    int attributes = 65535;

    protected FieldInfo(String name, String type, int modifiers, ConstantValue cv, ClassInfo ci, int idx, int off) {
        this.name = name;
        this.type = type;
        this.ci = ci;
        this.cv = cv;
        this.fieldIndex = idx;
        this.storageOffset = off;
        this.modifiers = modifiers;
    }

    public static FieldInfo create(Field f, ClassInfo ci, int idx, int off) {
        String name = f.getName();
        String type = Types.getCanonicalTypeName(f.getType().toString());
        ConstantValue cv = f.getConstantValue();
        int modifiers = f.getModifiers();
        FieldInfo ret = FieldInfo.create(name, type, modifiers, cv, ci, idx, off);
        ret.loadAnnotations(f.getAnnotationEntries());
        return ret;
    }

    public static FieldInfo create(String name, String type, int modifiers, ConstantValue cv, ClassInfo ci, int idx, int off) {
        FieldInfo ret = "boolean".equals(type) || "byte".equals(type) || "char".equals(type) || "short".equals(type) || "int".equals(type) ? new IntegerFieldInfo(name, type, modifiers, cv, ci, idx, off) : ("long".equals(type) ? new LongFieldInfo(name, type, modifiers, cv, ci, idx, off) : ("double".equals(type) ? new DoubleFieldInfo(name, type, modifiers, cv, ci, idx, off) : ("float".equals(type) ? new FloatFieldInfo(name, type, modifiers, cv, ci, idx, off) : new ReferenceFieldInfo(name, type, modifiers, cv, ci, idx, off))));
        return ret;
    }

    public abstract String valueToString(Fields var1);

    @Override
    public ClassInfo getClassInfo() {
        return this.ci;
    }

    public ConstantValue getConstantValue() {
        return this.cv;
    }

    public abstract Object getValueObject(Fields var1);

    public int getModifiers() {
        return this.modifiers;
    }

    public int getFieldIndex() {
        return this.fieldIndex;
    }

    public boolean isReference() {
        return false;
    }

    public boolean isArrayField() {
        return false;
    }

    public boolean isStatic() {
        return (this.modifiers & 8) != 0;
    }

    public boolean isFinal() {
        return (this.modifiers & 0x10) != 0;
    }

    public boolean isVolatile() {
        return (this.modifiers & 0x40) != 0;
    }

    public boolean isTransient() {
        return (this.modifiers & 0x80) != 0;
    }

    public boolean isPublic() {
        return (this.modifiers & 1) != 0;
    }

    public String getName() {
        return this.name;
    }

    public int getStorageSize() {
        return 1;
    }

    public String getType() {
        return this.type;
    }

    public ClassInfo getTypeClassInfo() {
        return ClassInfo.getClassInfo(this.type);
    }

    public abstract void initialize(ElementInfo var1);

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.isStatic()) {
            sb.append("static ");
        }
        if (this.isFinal()) {
            sb.append("final ");
        }
        sb.append(this.type);
        sb.append(' ');
        sb.append(this.ci.getName());
        sb.append('.');
        sb.append(this.name);
        return sb.toString();
    }

    void setAttributes(int a) {
        this.attributes = a;
    }

    public int getAttributes() {
        return this.attributes;
    }

    public int getStorageOffset() {
        return this.storageOffset;
    }

    public String getFullName() {
        return this.ci.getName() + '.' + this.name;
    }

    public boolean isUntracked() {
        return this.getAnnotation("gov.nasa.jpf.jvm.untracked.UntrackedField") != null;
    }
}

