/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.jpf.jvm;

import gov.nasa.jpf.jvm.DynamicArea;
import gov.nasa.jpf.jvm.ElementInfo;
import gov.nasa.jpf.jvm.ThreadInfo;
import java.io.PrintWriter;

public class ExceptionInfo {
    ElementInfo ei;
    ThreadInfo ti;

    ExceptionInfo(ThreadInfo xThread, ElementInfo xEi) {
        this.ti = xThread;
        this.ei = xEi;
    }

    public int getExceptionReference() {
        return this.ei.getIndex();
    }

    public String getExceptionClassname() {
        return this.ei.getClassInfo().getName();
    }

    public String getDetails() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getExceptionClassname());
        int msgRef = this.ei.getReferenceField("detailMessage");
        if (msgRef != -1) {
            Object eiMsg = DynamicArea.getHeap().get(msgRef);
            sb.append(" : ");
            sb.append(((ElementInfo)eiMsg).asString());
        }
        return sb.toString();
    }

    public ThreadInfo getThread() {
        return this.ti;
    }

    public void printOn(PrintWriter pw) {
        this.ti.printStackTrace(pw, this.ei.getIndex());
    }
}

