/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.jpf.jvm;

import gov.nasa.jpf.JPFException;
import gov.nasa.jpf.jvm.ClassInfo;
import gov.nasa.jpf.jvm.ElementInfo;
import gov.nasa.jpf.jvm.FieldInfo;
import gov.nasa.jpf.jvm.Fields;
import gov.nasa.jpf.jvm.Monitor;
import gov.nasa.jpf.jvm.ObjRef;
import gov.nasa.jpf.jvm.Ref;

public final class DynamicElementInfo
extends ElementInfo {
    public DynamicElementInfo() {
    }

    public DynamicElementInfo(Fields f, Monitor m) {
        super(f, m);
    }

    @Override
    public void setIntField(FieldInfo fi, int value) {
        if (fi.isReference()) {
            throw new JPFException("reference field: " + fi.getName());
        }
        this.cloneFields().setIntValue(this, fi.getStorageOffset(), value);
    }

    @Override
    public int getNumberOfFields() {
        return this.getClassInfo().getNumberOfInstanceFields();
    }

    @Override
    public FieldInfo getFieldInfo(int fieldIndex) {
        return this.getClassInfo().getInstanceField(fieldIndex);
    }

    @Override
    public DynamicElementInfo getFieldDereference(FieldInfo fi) {
        assert (fi.isReference());
        return (DynamicElementInfo)this.area.get(this.getIntField(fi));
    }

    @Override
    public FieldInfo getFieldInfo(String fname) {
        return this.getClassInfo().getInstanceField(fname);
    }

    @Override
    protected FieldInfo getDeclaredFieldInfo(String clsBase, String fname) {
        return ClassInfo.getClassInfo(clsBase).getDeclaredInstanceField(fname);
    }

    @Override
    protected ElementInfo getElementInfo(ClassInfo ci) {
        return this;
    }

    @Override
    protected Ref getRef() {
        return new ObjRef(this.getIndex());
    }
}

