/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.jpf.jvm;

import gov.nasa.jpf.jvm.MethodInfo;
import gov.nasa.jpf.jvm.StackFrame;
import gov.nasa.jpf.jvm.bytecode.Instruction;

public class DirectCallStackFrame
extends StackFrame {
    static final int OPERAND_INC = 5;
    static final int LOCAL_INC = 5;
    Instruction nextPc;

    public DirectCallStackFrame(MethodInfo stub) {
        super(stub, null);
    }

    public DirectCallStackFrame(MethodInfo stub, Instruction nextInsn) {
        super(stub, null);
        this.nextPc = nextInsn;
    }

    private DirectCallStackFrame() {
    }

    public void reset() {
        this.pc = this.mi.getInstruction(0);
    }

    public Instruction getNextPC() {
        return this.nextPc;
    }

    @Override
    public boolean isDirectCallFrame() {
        return true;
    }

    @Override
    public String getClassName() {
        return "<direct call>";
    }

    @Override
    public String getSourceFile() {
        return "<direct call>";
    }

    private void growOperands() {
        int newLen = this.operands.length + 5;
        int[] newOperands = new int[newLen];
        System.arraycopy(this.operands, 0, newOperands, 0, this.operands.length);
        this.operands = newOperands;
        boolean[] newIsOperandRef = new boolean[newLen];
        System.arraycopy(this.isOperandRef, 0, newIsOperandRef, 0, this.isOperandRef.length);
        this.isOperandRef = newIsOperandRef;
        if (this.operandAttr != null) {
            Object[] newOperandAttr = new Object[newLen];
            System.arraycopy(this.operandAttr, 0, newOperandAttr, 0, this.operandAttr.length);
            this.operandAttr = newOperandAttr;
        }
    }

    @Override
    public void push(int v, boolean ref) {
        if (this.top >= this.operands.length - 1) {
            this.growOperands();
        }
        super.push(v, ref);
    }

    private void growLocals(int idx) {
        int newLen = idx + 5;
        int[] newLocals = new int[newLen];
        System.arraycopy(this.locals, 0, newLocals, 0, this.locals.length);
        this.locals = newLocals;
        boolean[] newIsLocalRef = new boolean[newLen];
        System.arraycopy(this.isLocalRef, 0, newIsLocalRef, 0, this.isLocalRef.length);
        this.isLocalRef = newIsLocalRef;
        if (this.localAttr != null) {
            Object[] newLocalAttr = new Object[newLen];
            System.arraycopy(this.localAttr, 0, newLocalAttr, 0, this.localAttr.length);
            this.localAttr = newLocalAttr;
        }
    }

    @Override
    public void setLocalVariable(int index, int v, boolean ref) {
        if (index >= this.locals.length) {
            this.growLocals(index);
        }
        super.setLocalVariable(index, v, ref);
    }

    @Override
    public void setLongLocalVariable(int index, long v) {
        if (index + 1 >= this.locals.length) {
            this.growLocals(index + 1);
        }
        super.setLongLocalVariable(index, v);
    }

    @Override
    public void dup() {
        if (this.top >= this.operands.length - 1) {
            this.growOperands();
        }
        super.dup();
    }

    @Override
    public void dup2() {
        if (this.top >= this.operands.length - 2) {
            this.growOperands();
        }
        super.dup2();
    }
}

