/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.jpf.jvm;

import gov.nasa.jpf.Config;
import gov.nasa.jpf.JPFException;
import gov.nasa.jpf.jvm.ClassInfo;
import gov.nasa.jpf.jvm.InstructionFactory;
import gov.nasa.jpf.jvm.MethodInfo;
import gov.nasa.jpf.jvm.bytecode.Instruction;
import java.util.HashMap;
import org.apache.bcel.classfile.ConstantPool;
import org.apache.bcel.generic.InstructionHandle;

public class DefaultInstructionFactory
implements InstructionFactory {
    static final String DEFAULT_CLASS_PREFIX = "gov.nasa.jpf.jvm.bytecode.";
    protected HashMap<Class<?>, Class<? extends Instruction>> bcel2jpf = new HashMap(280);
    protected HashMap<String, Class<? extends Instruction>> map = new HashMap(280);
    protected ClassLoader loader;

    public DefaultInstructionFactory(Config conf) {
        this.loader = conf.getCurrentClassLoader();
    }

    protected Class<? extends Instruction> mapBcel2Jpf(Class<?> bcelClass) throws ClassNotFoundException {
        Class<? extends Instruction> jpf = this.bcel2jpf.get(bcelClass);
        if (jpf == null) {
            String name = bcelClass.getName();
            if (!name.startsWith("org.apache.bcel.generic.")) {
                throw new JPFException("not a BCEL instruction type: " + name);
            }
            name = DEFAULT_CLASS_PREFIX + name.substring(24);
            jpf = this.loader.loadClass(name).asSubclass(Instruction.class);
            this.bcel2jpf.put(bcelClass, jpf);
        }
        return jpf;
    }

    @Override
    public Instruction create(InstructionHandle h, int offset, MethodInfo m, ConstantPool cp) {
        try {
            Instruction insn = this.mapBcel2Jpf(h.getInstruction().getClass()).newInstance();
            insn.init(h, offset, m, cp);
            return insn;
        }
        catch (Throwable e) {
            throw new JPFException("creation of instruction " + h.getInstruction() + " failed: " + e);
        }
    }

    @Override
    public Instruction create(ClassInfo ciMth, String insnClsName) {
        try {
            Class<Instruction> cls = this.map.get(insnClsName);
            if (cls == null) {
                cls = this.loader.loadClass(DEFAULT_CLASS_PREFIX + insnClsName);
                this.map.put(insnClsName, cls);
            }
            return cls.newInstance();
        }
        catch (Throwable e) {
            throw new JPFException("creation of instruction " + insnClsName + " failed: " + e);
        }
    }
}

