/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.jpf.jvm;

import gov.nasa.jpf.jvm.DefaultAttributor;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;

public class ConfigAttributor
extends DefaultAttributor {
    private static final Pattern section_pattern = Pattern.compile("\\[([a-zA-Z]+)\\]");
    private static final Pattern atomic_rule_pattern = Pattern.compile("([^ ]+) +([^ ]+) +(true|false)");
    private List<NameRule> relevance_rules = new ArrayList<NameRule>();
    private List<NameRule> atomic_rules = new ArrayList<NameRule>();

    public ConfigAttributor() {
        try {
            this.parse("jpf-attributes");
        }
        catch (FileNotFoundException e) {
        }
        catch (IOException e) {
            System.err.println("IO exception reading attribute file: " + e);
            System.err.println("Ignoring file");
            this.relevance_rules.clear();
            this.atomic_rules.clear();
        }
    }

    @Override
    public boolean isMethodAtomic(JavaClass jc, Method mth, String uniqueName) {
        String cls = jc.getClassName();
        for (NameRule rule : this.atomic_rules) {
            if (!rule.isMatch(cls, uniqueName)) continue;
            System.out.println("Found atomic rule for " + cls + ":" + uniqueName);
            return rule.getResult() == 1;
        }
        return super.isMethodAtomic(jc, mth, uniqueName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parse(String filename) throws FileNotFoundException, IOException {
        BufferedReader config_file = new BufferedReader(new FileReader(filename));
        try {
            System.out.println("Using JPF attributes from " + filename);
            String line = config_file.readLine();
            String current_section = null;
            while (line != null) {
                if ((line = line.trim()).length() != 0 && line.charAt(0) != '#') {
                    if (line.charAt(0) == '[') {
                        current_section = this.parseSection(line);
                    } else if ("atomic".equals(current_section)) {
                        this.parseAtomicRule(line);
                    } else {
                        System.err.println("Rules found in section " + current_section + ", which is unknown.");
                    }
                }
                line = config_file.readLine();
            }
        }
        finally {
            config_file.close();
        }
    }

    private String parseSection(String line) {
        Matcher match = section_pattern.matcher(line);
        if (match.matches()) {
            return match.group(1);
        }
        System.err.println("Problem parsing section name " + line);
        return null;
    }

    private void parseAtomicRule(String line) {
        Matcher match = atomic_rule_pattern.matcher(line);
        if (match.matches()) {
            int result = 0;
            String value = match.group(3);
            if ("true".equals(value)) {
                result = 1;
            } else if ("false".equals(value)) {
                result = 0;
            } else {
                System.err.println("Unknown atomic value: " + value);
                return;
            }
            this.atomic_rules.add(new NameRule(match.group(1), match.group(2), result));
        } else {
            System.err.println("Atomic rule parse error on line: " + line);
        }
    }

    private static class NameRule {
        Pattern class_pattern;
        Pattern method_pattern;
        int result;

        NameRule(String class_pattern_string, String method_pattern_string, int value) {
            this.class_pattern = Pattern.compile(class_pattern_string);
            this.method_pattern = Pattern.compile(method_pattern_string);
            this.result = value;
        }

        boolean isMatch(String class_name, String method_name) {
            Matcher class_match = this.class_pattern.matcher(class_name);
            if (class_match.matches()) {
                return this.method_pattern.matcher(method_name).matches();
            }
            return false;
        }

        int getResult() {
            return this.result;
        }
    }
}

